@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Value object for saved search results.
 * @property category The category of the saved search. This helps the user to find a saved search faster.
 * @property displayName Saved search display name.
 * @property etag The ETag of the saved search. To override an existing saved search, use "*" or specify the current Etag
 * @property functionAlias The function alias if query serves as a function.
 * @property functionParameters The optional function parameters if query serves as a function. Value should be in the following format: 'param-name1:type1 = default_value1, param-name2:type2 = default_value2'. For more examples and proper syntax please refer to https://docs.microsoft.com/en-us/azure/kusto/query/functions/user-defined-functions.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property query The query expression for the saved search.
 * @property tags The tags attached to the saved search.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property version The version number of the query language. The current version is 2 and is the default.
 */
public data class GetSavedSearchResult(
    public val category: String,
    public val displayName: String,
    public val etag: String? = null,
    public val functionAlias: String? = null,
    public val functionParameters: String? = null,
    public val id: String,
    public val name: String,
    public val query: String,
    public val tags: List<TagResponse>? = null,
    public val type: String,
    public val version: Double? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.operationalinsights.outputs.GetSavedSearchResult): GetSavedSearchResult = GetSavedSearchResult(
            category = javaType.category(),
            displayName = javaType.displayName(),
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            functionAlias = javaType.functionAlias().map({ args0 -> args0 }).orElse(null),
            functionParameters = javaType.functionParameters().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            query = javaType.query(),
            tags = javaType.tags().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.operationalinsights.kotlin.outputs.TagResponse.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type(),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
