@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The top level storage insight resource container.
 * @property containers The names of the blob containers that the workspace should read
 * @property eTag The ETag of the storage insight.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property status The status of the storage insight
 * @property storageAccount The storage account connection details
 * @property tables The names of the Azure tables that the workspace should read
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetStorageInsightConfigResult(
    public val containers: List<String>? = null,
    public val eTag: String? = null,
    public val id: String,
    public val name: String,
    public val status: StorageInsightStatusResponse,
    public val storageAccount: StorageAccountResponse,
    public val tables: List<String>? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.operationalinsights.outputs.GetStorageInsightConfigResult): GetStorageInsightConfigResult = GetStorageInsightConfigResult(
            containers = javaType.containers().map({ args0 -> args0 }),
            eTag = javaType.eTag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            status = javaType.status().let({ args0 ->
                com.pulumi.azurenative.operationalinsights.kotlin.outputs.StorageInsightStatusResponse.Companion.toKotlin(args0)
            }),
            storageAccount = javaType.storageAccount().let({ args0 ->
                com.pulumi.azurenative.operationalinsights.kotlin.outputs.StorageAccountResponse.Companion.toKotlin(args0)
            }),
            tables = javaType.tables().map({ args0 -> args0 }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
