@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The top level Workspace resource container.
 * @property createdDate Workspace creation date.
 * @property customerId This is a read-only property. Represents the ID associated with the workspace.
 * @property defaultDataCollectionRuleResourceId The resource ID of the default Data Collection Rule to use for this workspace. Expected format is - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/dataCollectionRules/{dcrName}.
 * @property etag The etag of the workspace.
 * @property features Workspace features.
 * @property forceCmkForQuery Indicates whether customer managed storage is mandatory for query management.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property identity The identity of the resource.
 * @property location The geo-location where the resource lives
 * @property modifiedDate Workspace modification date.
 * @property name The name of the resource
 * @property privateLinkScopedResources List of linked private link scope resources.
 * @property provisioningState The provisioning state of the workspace.
 * @property publicNetworkAccessForIngestion The network access type for accessing Log Analytics ingestion.
 * @property publicNetworkAccessForQuery The network access type for accessing Log Analytics query.
 * @property retentionInDays The workspace data retention in days. Allowed values are per pricing plan. See pricing tiers documentation for details.
 * @property sku The SKU of the workspace.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property workspaceCapping The daily volume cap for ingestion.
 */
public data class GetWorkspaceResult(
    public val createdDate: String,
    public val customerId: String,
    public val defaultDataCollectionRuleResourceId: String? = null,
    public val etag: String? = null,
    public val features: WorkspaceFeaturesResponse? = null,
    public val forceCmkForQuery: Boolean? = null,
    public val id: String,
    public val identity: IdentityResponse? = null,
    public val location: String,
    public val modifiedDate: String,
    public val name: String,
    public val privateLinkScopedResources: List<PrivateLinkScopedResourceResponse>,
    public val provisioningState: String,
    public val publicNetworkAccessForIngestion: String? = null,
    public val publicNetworkAccessForQuery: String? = null,
    public val retentionInDays: Int? = null,
    public val sku: WorkspaceSkuResponse? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val workspaceCapping: WorkspaceCappingResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.operationalinsights.outputs.GetWorkspaceResult): GetWorkspaceResult = GetWorkspaceResult(
            createdDate = javaType.createdDate(),
            customerId = javaType.customerId(),
            defaultDataCollectionRuleResourceId = javaType.defaultDataCollectionRuleResourceId().map({ args0 ->
                args0
            }).orElse(null),
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            features = javaType.features().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.operationalinsights.kotlin.outputs.WorkspaceFeaturesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            forceCmkForQuery = javaType.forceCmkForQuery().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.operationalinsights.kotlin.outputs.IdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location(),
            modifiedDate = javaType.modifiedDate(),
            name = javaType.name(),
            privateLinkScopedResources = javaType.privateLinkScopedResources().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.operationalinsights.kotlin.outputs.PrivateLinkScopedResourceResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            publicNetworkAccessForIngestion = javaType.publicNetworkAccessForIngestion().map({ args0 ->
                args0
            }).orElse(null),
            publicNetworkAccessForQuery = javaType.publicNetworkAccessForQuery().map({ args0 ->
                args0
            }).orElse(null),
            retentionInDays = javaType.retentionInDays().map({ args0 -> args0 }).orElse(null),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.operationalinsights.kotlin.outputs.WorkspaceSkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.operationalinsights.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            workspaceCapping = javaType.workspaceCapping().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.operationalinsights.kotlin.outputs.WorkspaceCappingResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
