@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The shared keys for a workspace.
 * @property primarySharedKey The primary shared key of a workspace.
 * @property secondarySharedKey The secondary shared key of a workspace.
 */
public data class GetWorkspaceSharedKeysResult(
    public val primarySharedKey: String? = null,
    public val secondarySharedKey: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.operationalinsights.outputs.GetWorkspaceSharedKeysResult): GetWorkspaceSharedKeysResult = GetWorkspaceSharedKeysResult(
            primarySharedKey = javaType.primarySharedKey().map({ args0 -> args0 }).orElse(null),
            secondarySharedKey = javaType.secondarySharedKey().map({ args0 -> args0 }).orElse(null),
        )
    }
}
