@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The key vault properties.
 * @property keyName The name of the key associated with the Log Analytics cluster.
 * @property keyRsaSize Selected key minimum required size.
 * @property keyVaultUri The Key Vault uri which holds they key associated with the Log Analytics cluster.
 * @property keyVersion The version of the key associated with the Log Analytics cluster.
 */
public data class KeyVaultPropertiesResponse(
    public val keyName: String? = null,
    public val keyRsaSize: Int? = null,
    public val keyVaultUri: String? = null,
    public val keyVersion: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.operationalinsights.outputs.KeyVaultPropertiesResponse): KeyVaultPropertiesResponse = KeyVaultPropertiesResponse(
            keyName = javaType.keyName().map({ args0 -> args0 }).orElse(null),
            keyRsaSize = javaType.keyRsaSize().map({ args0 -> args0 }).orElse(null),
            keyVaultUri = javaType.keyVaultUri().map({ args0 -> args0 }).orElse(null),
            keyVersion = javaType.keyVersion().map({ args0 -> args0 }).orElse(null),
        )
    }
}
