@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The related metadata items for the function.
 * @property categories The related categories for the function.
 * @property resourceTypes The related resource types for the function.
 * @property solutions The related Log Analytics solutions for the function.
 */
public data class LogAnalyticsQueryPackQueryPropertiesResponseRelated(
    public val categories: List<String>? = null,
    public val resourceTypes: List<String>? = null,
    public val solutions: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.operationalinsights.outputs.LogAnalyticsQueryPackQueryPropertiesResponseRelated): LogAnalyticsQueryPackQueryPropertiesResponseRelated =
            LogAnalyticsQueryPackQueryPropertiesResponseRelated(
                categories = javaType.categories().map({ args0 -> args0 }),
                resourceTypes = javaType.resourceTypes().map({ args0 -> args0 }),
                solutions = javaType.solutions().map({ args0 -> args0 }),
            )
    }
}
