@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Restore parameters.
 * @property azureAsyncOperationId Search results table async operation id.
 * @property endRestoreTime The timestamp to end the restore by (UTC).
 * @property sourceTable The table to restore data from.
 * @property startRestoreTime The timestamp to start the restore from (UTC).
 */
public data class RestoredLogsResponse(
    public val azureAsyncOperationId: String,
    public val endRestoreTime: String? = null,
    public val sourceTable: String? = null,
    public val startRestoreTime: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.operationalinsights.outputs.RestoredLogsResponse): RestoredLogsResponse = RestoredLogsResponse(
            azureAsyncOperationId = javaType.azureAsyncOperationId(),
            endRestoreTime = javaType.endRestoreTime().map({ args0 -> args0 }).orElse(null),
            sourceTable = javaType.sourceTable().map({ args0 -> args0 }).orElse(null),
            startRestoreTime = javaType.startRestoreTime().map({ args0 -> args0 }).orElse(null),
        )
    }
}
