@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.Suppress

/**
 * Search job execution statistics.
 * @property ingestedRecords The number of rows that were returned by the search job.
 * @property progress Search job completion percentage.
 * @property scannedGb Search job: Amount of scanned data.
 */
public data class ResultStatisticsResponse(
    public val ingestedRecords: Int,
    public val progress: Double,
    public val scannedGb: Double,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.operationalinsights.outputs.ResultStatisticsResponse): ResultStatisticsResponse = ResultStatisticsResponse(
            ingestedRecords = javaType.ingestedRecords(),
            progress = javaType.progress(),
            scannedGb = javaType.scannedGb(),
        )
    }
}
