@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Table's schema.
 * @property categories Table category.
 * @property columns A list of table custom columns.
 * @property description Table description.
 * @property displayName Table display name.
 * @property labels Table labels.
 * @property name Table name.
 * @property solutions List of solutions the table is affiliated with
 * @property source Table's creator.
 * @property standardColumns A list of table standard columns.
 * @property tableSubType The subtype describes what APIs can be used to interact with the table, and what features are available against it.
 * @property tableType Table's creator.
 */
public data class SchemaResponse(
    public val categories: List<String>,
    public val columns: List<ColumnResponse>? = null,
    public val description: String? = null,
    public val displayName: String? = null,
    public val labels: List<String>,
    public val name: String? = null,
    public val solutions: List<String>,
    public val source: String,
    public val standardColumns: List<ColumnResponse>,
    public val tableSubType: String,
    public val tableType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.operationalinsights.outputs.SchemaResponse): SchemaResponse = SchemaResponse(
            categories = javaType.categories().map({ args0 -> args0 }),
            columns = javaType.columns().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.operationalinsights.kotlin.outputs.ColumnResponse.Companion.toKotlin(args0)
                })
            }),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            labels = javaType.labels().map({ args0 -> args0 }),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            solutions = javaType.solutions().map({ args0 -> args0 }),
            source = javaType.source(),
            standardColumns = javaType.standardColumns().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.operationalinsights.kotlin.outputs.ColumnResponse.Companion.toKotlin(args0)
                })
            }),
            tableSubType = javaType.tableSubType(),
            tableType = javaType.tableType(),
        )
    }
}
