@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Parameters of the search job that initiated this table.
 * @property azureAsyncOperationId Search results table async operation id.
 * @property description Search job Description.
 * @property endSearchTime The timestamp to end the search by (UTC)
 * @property limit Limit the search job to return up to specified number of rows.
 * @property query Search job query.
 * @property sourceTable The table used in the search job.
 * @property startSearchTime The timestamp to start the search from (UTC)
 */
public data class SearchResultsResponse(
    public val azureAsyncOperationId: String,
    public val description: String? = null,
    public val endSearchTime: String? = null,
    public val limit: Int? = null,
    public val query: String? = null,
    public val sourceTable: String,
    public val startSearchTime: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.operationalinsights.outputs.SearchResultsResponse): SearchResultsResponse = SearchResultsResponse(
            azureAsyncOperationId = javaType.azureAsyncOperationId(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            endSearchTime = javaType.endSearchTime().map({ args0 -> args0 }).orElse(null),
            limit = javaType.limit().map({ args0 -> args0 }).orElse(null),
            query = javaType.query().map({ args0 -> args0 }).orElse(null),
            sourceTable = javaType.sourceTable(),
            startSearchTime = javaType.startSearchTime().map({ args0 -> args0 }).orElse(null),
        )
    }
}
