@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The status of the storage insight.
 * @property description Description of the state of the storage insight.
 * @property state The state of the storage insight connection to the workspace
 */
public data class StorageInsightStatusResponse(
    public val description: String? = null,
    public val state: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.operationalinsights.outputs.StorageInsightStatusResponse): StorageInsightStatusResponse = StorageInsightStatusResponse(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            state = javaType.state(),
        )
    }
}
