@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * User assigned identity properties.
 * @property clientId The client id of user assigned identity.
 * @property principalId The principal id of user assigned identity.
 */
public data class UserIdentityPropertiesResponse(
    public val clientId: String,
    public val principalId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.operationalinsights.outputs.UserIdentityPropertiesResponse): UserIdentityPropertiesResponse = UserIdentityPropertiesResponse(
            clientId = javaType.clientId(),
            principalId = javaType.principalId(),
        )
    }
}
