@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * The daily volume cap for ingestion.
 * @property dailyQuotaGb The workspace daily quota for ingestion.
 * @property dataIngestionStatus The status of data ingestion for this workspace.
 * @property quotaNextResetTime The time when the quota will be rest.
 */
public data class WorkspaceCappingResponse(
    public val dailyQuotaGb: Double? = null,
    public val dataIngestionStatus: String,
    public val quotaNextResetTime: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.operationalinsights.outputs.WorkspaceCappingResponse): WorkspaceCappingResponse = WorkspaceCappingResponse(
            dailyQuotaGb = javaType.dailyQuotaGb().map({ args0 -> args0 }).orElse(null),
            dataIngestionStatus = javaType.dataIngestionStatus(),
            quotaNextResetTime = javaType.quotaNextResetTime(),
        )
    }
}
