@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationsmanagement.kotlin

import com.pulumi.azurenative.operationsmanagement.OperationsmanagementFunctions.getManagementAssociationPlain
import com.pulumi.azurenative.operationsmanagement.OperationsmanagementFunctions.getManagementConfigurationPlain
import com.pulumi.azurenative.operationsmanagement.OperationsmanagementFunctions.getSolutionPlain
import com.pulumi.azurenative.operationsmanagement.kotlin.inputs.GetManagementAssociationPlainArgs
import com.pulumi.azurenative.operationsmanagement.kotlin.inputs.GetManagementAssociationPlainArgsBuilder
import com.pulumi.azurenative.operationsmanagement.kotlin.inputs.GetManagementConfigurationPlainArgs
import com.pulumi.azurenative.operationsmanagement.kotlin.inputs.GetManagementConfigurationPlainArgsBuilder
import com.pulumi.azurenative.operationsmanagement.kotlin.inputs.GetSolutionPlainArgs
import com.pulumi.azurenative.operationsmanagement.kotlin.inputs.GetSolutionPlainArgsBuilder
import com.pulumi.azurenative.operationsmanagement.kotlin.outputs.GetManagementAssociationResult
import com.pulumi.azurenative.operationsmanagement.kotlin.outputs.GetManagementConfigurationResult
import com.pulumi.azurenative.operationsmanagement.kotlin.outputs.GetSolutionResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.operationsmanagement.kotlin.outputs.GetManagementAssociationResult.Companion.toKotlin as getManagementAssociationResultToKotlin
import com.pulumi.azurenative.operationsmanagement.kotlin.outputs.GetManagementConfigurationResult.Companion.toKotlin as getManagementConfigurationResultToKotlin
import com.pulumi.azurenative.operationsmanagement.kotlin.outputs.GetSolutionResult.Companion.toKotlin as getSolutionResultToKotlin

public object OperationsmanagementFunctions {
    /**
     * Retrieves the user ManagementAssociation.
     * Azure REST API version: 2015-11-01-preview.
     * @param argument null
     * @return The container for solution.
     */
    public suspend fun getManagementAssociation(argument: GetManagementAssociationPlainArgs): GetManagementAssociationResult =
        getManagementAssociationResultToKotlin(getManagementAssociationPlain(argument.toJava()).await())

    /**
     * @see [getManagementAssociation].
     * @param managementAssociationName User ManagementAssociation Name.
     * @param providerName Provider name for the parent resource.
     * @param resourceGroupName The name of the resource group to get. The name is case insensitive.
     * @param resourceName Parent resource name.
     * @param resourceType Resource type for the parent resource
     * @return The container for solution.
     */
    public suspend fun getManagementAssociation(
        managementAssociationName: String,
        providerName: String,
        resourceGroupName: String,
        resourceName: String,
        resourceType: String,
    ): GetManagementAssociationResult {
        val argument = GetManagementAssociationPlainArgs(
            managementAssociationName = managementAssociationName,
            providerName = providerName,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
            resourceType = resourceType,
        )
        return getManagementAssociationResultToKotlin(getManagementAssociationPlain(argument.toJava()).await())
    }

    /**
     * @see [getManagementAssociation].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;operationsmanagement&#46;kotlin&#46;inputs&#46;GetManagementAssociationPlainArgs].
     * @return The container for solution.
     */
    public suspend fun getManagementAssociation(argument: suspend GetManagementAssociationPlainArgsBuilder.() -> Unit): GetManagementAssociationResult {
        val builder = GetManagementAssociationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getManagementAssociationResultToKotlin(getManagementAssociationPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieves the user ManagementConfiguration.
     * Azure REST API version: 2015-11-01-preview.
     * @param argument null
     * @return The container for solution.
     */
    public suspend fun getManagementConfiguration(argument: GetManagementConfigurationPlainArgs): GetManagementConfigurationResult =
        getManagementConfigurationResultToKotlin(getManagementConfigurationPlain(argument.toJava()).await())

    /**
     * @see [getManagementConfiguration].
     * @param managementConfigurationName User Management Configuration Name.
     * @param resourceGroupName The name of the resource group to get. The name is case insensitive.
     * @return The container for solution.
     */
    public suspend fun getManagementConfiguration(
        managementConfigurationName: String,
        resourceGroupName: String,
    ): GetManagementConfigurationResult {
        val argument = GetManagementConfigurationPlainArgs(
            managementConfigurationName = managementConfigurationName,
            resourceGroupName = resourceGroupName,
        )
        return getManagementConfigurationResultToKotlin(getManagementConfigurationPlain(argument.toJava()).await())
    }

    /**
     * @see [getManagementConfiguration].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;operationsmanagement&#46;kotlin&#46;inputs&#46;GetManagementConfigurationPlainArgs].
     * @return The container for solution.
     */
    public suspend fun getManagementConfiguration(argument: suspend GetManagementConfigurationPlainArgsBuilder.() -> Unit): GetManagementConfigurationResult {
        val builder = GetManagementConfigurationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getManagementConfigurationResultToKotlin(getManagementConfigurationPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieves the user solution.
     * Azure REST API version: 2015-11-01-preview.
     * @param argument null
     * @return The container for solution.
     */
    public suspend fun getSolution(argument: GetSolutionPlainArgs): GetSolutionResult =
        getSolutionResultToKotlin(getSolutionPlain(argument.toJava()).await())

    /**
     * @see [getSolution].
     * @param resourceGroupName The name of the resource group to get. The name is case insensitive.
     * @param solutionName User Solution Name.
     * @return The container for solution.
     */
    public suspend fun getSolution(resourceGroupName: String, solutionName: String): GetSolutionResult {
        val argument = GetSolutionPlainArgs(
            resourceGroupName = resourceGroupName,
            solutionName = solutionName,
        )
        return getSolutionResultToKotlin(getSolutionPlain(argument.toJava()).await())
    }

    /**
     * @see [getSolution].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;operationsmanagement&#46;kotlin&#46;inputs&#46;GetSolutionPlainArgs].
     * @return The container for solution.
     */
    public suspend fun getSolution(argument: suspend GetSolutionPlainArgsBuilder.() -> Unit): GetSolutionResult {
        val builder = GetSolutionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSolutionResultToKotlin(getSolutionPlain(builtArgument.toJava()).await())
    }
}
