@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationsmanagement.kotlin

import com.pulumi.azurenative.operationsmanagement.kotlin.outputs.SolutionPlanResponse
import com.pulumi.azurenative.operationsmanagement.kotlin.outputs.SolutionPropertiesResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.operationsmanagement.kotlin.outputs.SolutionPlanResponse.Companion.toKotlin as solutionPlanResponseToKotlin
import com.pulumi.azurenative.operationsmanagement.kotlin.outputs.SolutionPropertiesResponse.Companion.toKotlin as solutionPropertiesResponseToKotlin

/**
 * Builder for [Solution].
 */
@PulumiTagMarker
public class SolutionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SolutionArgs = SolutionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SolutionArgsBuilder.() -> Unit) {
        val builder = SolutionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Solution {
        val builtJavaResource =
            com.pulumi.azurenative.operationsmanagement.Solution(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return Solution(builtJavaResource)
    }
}

/**
 * The container for solution.
 * Azure REST API version: 2015-11-01-preview. Prior API version in Azure Native 1.x: 2015-11-01-preview.
 * ## Example Usage
 * ### SolutionCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var solution = new AzureNative.OperationsManagement.Solution("solution", new()
 *     {
 *         Location = "East US",
 *         Plan = new AzureNative.OperationsManagement.Inputs.SolutionPlanArgs
 *         {
 *             Name = "name1",
 *             Product = "product1",
 *             PromotionCode = "promocode1",
 *             Publisher = "publisher1",
 *         },
 *         Properties = new AzureNative.OperationsManagement.Inputs.SolutionPropertiesArgs
 *         {
 *             ContainedResources = new[]
 *             {
 *                 "/subscriptions/sub2/resourceGroups/rg2/providers/provider1/resources/resource1",
 *                 "/subscriptions/sub2/resourceGroups/rg2/providers/provider2/resources/resource2",
 *             },
 *             ReferencedResources = new[]
 *             {
 *                 "/subscriptions/sub2/resourceGroups/rg2/providers/provider1/resources/resource2",
 *                 "/subscriptions/sub2/resourceGroups/rg2/providers/provider2/resources/resource3",
 *             },
 *             WorkspaceResourceId = "/subscriptions/sub2/resourceGroups/rg2/providers/Microsoft.OperationalInsights/workspaces/ws1",
 *         },
 *         ResourceGroupName = "rg1",
 *         SolutionName = "solution1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/operationsmanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := operationsmanagement.NewSolution(ctx, "solution", &operationsmanagement.SolutionArgs{
 * 			Location: pulumi.String("East US"),
 * 			Plan: &operationsmanagement.SolutionPlanArgs{
 * 				Name:          pulumi.String("name1"),
 * 				Product:       pulumi.String("product1"),
 * 				PromotionCode: pulumi.String("promocode1"),
 * 				Publisher:     pulumi.String("publisher1"),
 * 			},
 * 			Properties: &operationsmanagement.SolutionPropertiesArgs{
 * 				ContainedResources: pulumi.StringArray{
 * 					pulumi.String("/subscriptions/sub2/resourceGroups/rg2/providers/provider1/resources/resource1"),
 * 					pulumi.String("/subscriptions/sub2/resourceGroups/rg2/providers/provider2/resources/resource2"),
 * 				},
 * 				ReferencedResources: pulumi.StringArray{
 * 					pulumi.String("/subscriptions/sub2/resourceGroups/rg2/providers/provider1/resources/resource2"),
 * 					pulumi.String("/subscriptions/sub2/resourceGroups/rg2/providers/provider2/resources/resource3"),
 * 				},
 * 				WorkspaceResourceId: pulumi.String("/subscriptions/sub2/resourceGroups/rg2/providers/Microsoft.OperationalInsights/workspaces/ws1"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			SolutionName:      pulumi.String("solution1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.operationsmanagement.Solution;
 * import com.pulumi.azurenative.operationsmanagement.SolutionArgs;
 * import com.pulumi.azurenative.operationsmanagement.inputs.SolutionPlanArgs;
 * import com.pulumi.azurenative.operationsmanagement.inputs.SolutionPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var solution = new Solution("solution", SolutionArgs.builder()
 *             .location("East US")
 *             .plan(SolutionPlanArgs.builder()
 *                 .name("name1")
 *                 .product("product1")
 *                 .promotionCode("promocode1")
 *                 .publisher("publisher1")
 *                 .build())
 *             .properties(SolutionPropertiesArgs.builder()
 *                 .containedResources(
 *                     "/subscriptions/sub2/resourceGroups/rg2/providers/provider1/resources/resource1",
 *                     "/subscriptions/sub2/resourceGroups/rg2/providers/provider2/resources/resource2")
 *                 .referencedResources(
 *                     "/subscriptions/sub2/resourceGroups/rg2/providers/provider1/resources/resource2",
 *                     "/subscriptions/sub2/resourceGroups/rg2/providers/provider2/resources/resource3")
 *                 .workspaceResourceId("/subscriptions/sub2/resourceGroups/rg2/providers/Microsoft.OperationalInsights/workspaces/ws1")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .solutionName("solution1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:operationsmanagement:Solution solution1 /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationsManagement/solutions/{solutionName}
 * ```
 */
public class Solution internal constructor(
    override val javaResource: com.pulumi.azurenative.operationsmanagement.Solution,
) : KotlinCustomResource(javaResource, SolutionMapper) {
    /**
     * Resource location
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Plan for solution object supported by the OperationsManagement resource provider.
     */
    public val plan: Output<SolutionPlanResponse>?
        get() = javaResource.plan().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    solutionPlanResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Properties for solution object supported by the OperationsManagement resource provider.
     */
    public val properties: Output<SolutionPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                solutionPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SolutionMapper : ResourceMapper<Solution> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.operationsmanagement.Solution::class == javaResource::class

    override fun map(javaResource: Resource): Solution = Solution(
        javaResource as
            com.pulumi.azurenative.operationsmanagement.Solution,
    )
}

/**
 * @see [Solution].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Solution].
 */
public suspend fun solution(name: String, block: suspend SolutionResourceBuilder.() -> Unit): Solution {
    val builder = SolutionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Solution].
 * @param name The _unique_ name of the resulting resource.
 */
public fun solution(name: String): Solution {
    val builder = SolutionResourceBuilder()
    builder.name(name)
    return builder.build()
}
