@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationsmanagement.kotlin

import com.pulumi.azurenative.operationsmanagement.SolutionArgs.builder
import com.pulumi.azurenative.operationsmanagement.kotlin.inputs.SolutionPlanArgs
import com.pulumi.azurenative.operationsmanagement.kotlin.inputs.SolutionPlanArgsBuilder
import com.pulumi.azurenative.operationsmanagement.kotlin.inputs.SolutionPropertiesArgs
import com.pulumi.azurenative.operationsmanagement.kotlin.inputs.SolutionPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The container for solution.
 * Azure REST API version: 2015-11-01-preview. Prior API version in Azure Native 1.x: 2015-11-01-preview.
 * ## Example Usage
 * ### SolutionCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var solution = new AzureNative.OperationsManagement.Solution("solution", new()
 *     {
 *         Location = "East US",
 *         Plan = new AzureNative.OperationsManagement.Inputs.SolutionPlanArgs
 *         {
 *             Name = "name1",
 *             Product = "product1",
 *             PromotionCode = "promocode1",
 *             Publisher = "publisher1",
 *         },
 *         Properties = new AzureNative.OperationsManagement.Inputs.SolutionPropertiesArgs
 *         {
 *             ContainedResources = new[]
 *             {
 *                 "/subscriptions/sub2/resourceGroups/rg2/providers/provider1/resources/resource1",
 *                 "/subscriptions/sub2/resourceGroups/rg2/providers/provider2/resources/resource2",
 *             },
 *             ReferencedResources = new[]
 *             {
 *                 "/subscriptions/sub2/resourceGroups/rg2/providers/provider1/resources/resource2",
 *                 "/subscriptions/sub2/resourceGroups/rg2/providers/provider2/resources/resource3",
 *             },
 *             WorkspaceResourceId = "/subscriptions/sub2/resourceGroups/rg2/providers/Microsoft.OperationalInsights/workspaces/ws1",
 *         },
 *         ResourceGroupName = "rg1",
 *         SolutionName = "solution1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/operationsmanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := operationsmanagement.NewSolution(ctx, "solution", &operationsmanagement.SolutionArgs{
 * 			Location: pulumi.String("East US"),
 * 			Plan: &operationsmanagement.SolutionPlanArgs{
 * 				Name:          pulumi.String("name1"),
 * 				Product:       pulumi.String("product1"),
 * 				PromotionCode: pulumi.String("promocode1"),
 * 				Publisher:     pulumi.String("publisher1"),
 * 			},
 * 			Properties: &operationsmanagement.SolutionPropertiesArgs{
 * 				ContainedResources: pulumi.StringArray{
 * 					pulumi.String("/subscriptions/sub2/resourceGroups/rg2/providers/provider1/resources/resource1"),
 * 					pulumi.String("/subscriptions/sub2/resourceGroups/rg2/providers/provider2/resources/resource2"),
 * 				},
 * 				ReferencedResources: pulumi.StringArray{
 * 					pulumi.String("/subscriptions/sub2/resourceGroups/rg2/providers/provider1/resources/resource2"),
 * 					pulumi.String("/subscriptions/sub2/resourceGroups/rg2/providers/provider2/resources/resource3"),
 * 				},
 * 				WorkspaceResourceId: pulumi.String("/subscriptions/sub2/resourceGroups/rg2/providers/Microsoft.OperationalInsights/workspaces/ws1"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			SolutionName:      pulumi.String("solution1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.operationsmanagement.Solution;
 * import com.pulumi.azurenative.operationsmanagement.SolutionArgs;
 * import com.pulumi.azurenative.operationsmanagement.inputs.SolutionPlanArgs;
 * import com.pulumi.azurenative.operationsmanagement.inputs.SolutionPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var solution = new Solution("solution", SolutionArgs.builder()
 *             .location("East US")
 *             .plan(SolutionPlanArgs.builder()
 *                 .name("name1")
 *                 .product("product1")
 *                 .promotionCode("promocode1")
 *                 .publisher("publisher1")
 *                 .build())
 *             .properties(SolutionPropertiesArgs.builder()
 *                 .containedResources(
 *                     "/subscriptions/sub2/resourceGroups/rg2/providers/provider1/resources/resource1",
 *                     "/subscriptions/sub2/resourceGroups/rg2/providers/provider2/resources/resource2")
 *                 .referencedResources(
 *                     "/subscriptions/sub2/resourceGroups/rg2/providers/provider1/resources/resource2",
 *                     "/subscriptions/sub2/resourceGroups/rg2/providers/provider2/resources/resource3")
 *                 .workspaceResourceId("/subscriptions/sub2/resourceGroups/rg2/providers/Microsoft.OperationalInsights/workspaces/ws1")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .solutionName("solution1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:operationsmanagement:Solution solution1 /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationsManagement/solutions/{solutionName}
 * ```
 * @property location Resource location
 * @property plan Plan for solution object supported by the OperationsManagement resource provider.
 * @property properties Properties for solution object supported by the OperationsManagement resource provider.
 * @property resourceGroupName The name of the resource group to get. The name is case insensitive.
 * @property solutionName User Solution Name.
 * @property tags Resource tags
 */
public data class SolutionArgs(
    public val location: Output<String>? = null,
    public val plan: Output<SolutionPlanArgs>? = null,
    public val properties: Output<SolutionPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val solutionName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.operationsmanagement.SolutionArgs> {
    override fun toJava(): com.pulumi.azurenative.operationsmanagement.SolutionArgs =
        com.pulumi.azurenative.operationsmanagement.SolutionArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .plan(plan?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .solutionName(solutionName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [SolutionArgs].
 */
@PulumiTagMarker
public class SolutionArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var plan: Output<SolutionPlanArgs>? = null

    private var properties: Output<SolutionPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var solutionName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Resource location
     */
    @JvmName("vghhnvfaaydaiplf")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Plan for solution object supported by the OperationsManagement resource provider.
     */
    @JvmName("rwbothsebplarxxl")
    public suspend fun plan(`value`: Output<SolutionPlanArgs>) {
        this.plan = value
    }

    /**
     * @param value Properties for solution object supported by the OperationsManagement resource provider.
     */
    @JvmName("fgwjvnaxddmvlinb")
    public suspend fun properties(`value`: Output<SolutionPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group to get. The name is case insensitive.
     */
    @JvmName("hhksowgmnaejdfys")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value User Solution Name.
     */
    @JvmName("bbxanueloykjyqwt")
    public suspend fun solutionName(`value`: Output<String>) {
        this.solutionName = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("lflbuawvagujcxid")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Resource location
     */
    @JvmName("bsglmhwhpfieoqjg")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Plan for solution object supported by the OperationsManagement resource provider.
     */
    @JvmName("oydgekkwekipgkjm")
    public suspend fun plan(`value`: SolutionPlanArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.plan = mapped
    }

    /**
     * @param argument Plan for solution object supported by the OperationsManagement resource provider.
     */
    @JvmName("srioktogjydjlyoh")
    public suspend fun plan(argument: suspend SolutionPlanArgsBuilder.() -> Unit) {
        val toBeMapped = SolutionPlanArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.plan = mapped
    }

    /**
     * @param value Properties for solution object supported by the OperationsManagement resource provider.
     */
    @JvmName("topvarrexsyspgma")
    public suspend fun properties(`value`: SolutionPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties for solution object supported by the OperationsManagement resource provider.
     */
    @JvmName("vgcvxfoiwpkyxcyq")
    public suspend fun properties(argument: suspend SolutionPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = SolutionPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group to get. The name is case insensitive.
     */
    @JvmName("cvvwvcanqggsxwmn")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value User Solution Name.
     */
    @JvmName("tvkomxbbicgntywm")
    public suspend fun solutionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.solutionName = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("olkktkebhsjspwdj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("rgmwlbkjumesweat")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): SolutionArgs = SolutionArgs(
        location = location,
        plan = plan,
        properties = properties,
        resourceGroupName = resourceGroupName,
        solutionName = solutionName,
        tags = tags,
    )
}
