@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationsmanagement.kotlin.inputs

import com.pulumi.azurenative.operationsmanagement.inputs.SolutionPlanArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Plan for solution object supported by the OperationsManagement resource provider.
 * @property name name of the solution to be created. For Microsoft published solution it should be in the format of solutionType(workspaceName). SolutionType part is case sensitive. For third party solution, it can be anything.
 * @property product name of the solution to enabled/add. For Microsoft published gallery solution it should be in the format of OMSGallery/<solutionType>. This is case sensitive
 * @property promotionCode promotionCode, Not really used now, can you left as empty
 * @property publisher Publisher name. For gallery solution, it is Microsoft.
 */
public data class SolutionPlanArgs(
    public val name: Output<String>? = null,
    public val product: Output<String>? = null,
    public val promotionCode: Output<String>? = null,
    public val publisher: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.operationsmanagement.inputs.SolutionPlanArgs> {
    override fun toJava(): com.pulumi.azurenative.operationsmanagement.inputs.SolutionPlanArgs =
        com.pulumi.azurenative.operationsmanagement.inputs.SolutionPlanArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .product(product?.applyValue({ args0 -> args0 }))
            .promotionCode(promotionCode?.applyValue({ args0 -> args0 }))
            .publisher(publisher?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SolutionPlanArgs].
 */
@PulumiTagMarker
public class SolutionPlanArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var product: Output<String>? = null

    private var promotionCode: Output<String>? = null

    private var publisher: Output<String>? = null

    /**
     * @param value name of the solution to be created. For Microsoft published solution it should be in the format of solutionType(workspaceName). SolutionType part is case sensitive. For third party solution, it can be anything.
     */
    @JvmName("iyhejomagdsksebv")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value name of the solution to enabled/add. For Microsoft published gallery solution it should be in the format of OMSGallery/<solutionType>. This is case sensitive
     */
    @JvmName("aarbmrntgrbnwxyq")
    public suspend fun product(`value`: Output<String>) {
        this.product = value
    }

    /**
     * @param value promotionCode, Not really used now, can you left as empty
     */
    @JvmName("raallwuqgswxlmxi")
    public suspend fun promotionCode(`value`: Output<String>) {
        this.promotionCode = value
    }

    /**
     * @param value Publisher name. For gallery solution, it is Microsoft.
     */
    @JvmName("trmmfmemsrqfsedj")
    public suspend fun publisher(`value`: Output<String>) {
        this.publisher = value
    }

    /**
     * @param value name of the solution to be created. For Microsoft published solution it should be in the format of solutionType(workspaceName). SolutionType part is case sensitive. For third party solution, it can be anything.
     */
    @JvmName("hnuwobteyxaqdhef")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value name of the solution to enabled/add. For Microsoft published gallery solution it should be in the format of OMSGallery/<solutionType>. This is case sensitive
     */
    @JvmName("gklhwoyvwkhtfvxe")
    public suspend fun product(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.product = mapped
    }

    /**
     * @param value promotionCode, Not really used now, can you left as empty
     */
    @JvmName("fcdsrobyrygyfbhi")
    public suspend fun promotionCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.promotionCode = mapped
    }

    /**
     * @param value Publisher name. For gallery solution, it is Microsoft.
     */
    @JvmName("ghynfdrgdilmgxpa")
    public suspend fun publisher(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publisher = mapped
    }

    internal fun build(): SolutionPlanArgs = SolutionPlanArgs(
        name = name,
        product = product,
        promotionCode = promotionCode,
        publisher = publisher,
    )
}
