@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationsmanagement.kotlin.inputs

import com.pulumi.azurenative.operationsmanagement.inputs.SolutionPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Solution properties supported by the OperationsManagement resource provider.
 * @property containedResources The azure resources that will be contained within the solutions. They will be locked and gets deleted automatically when the solution is deleted.
 * @property referencedResources The resources that will be referenced from this solution. Deleting any of those solution out of band will break the solution.
 * @property workspaceResourceId The azure resourceId for the workspace where the solution will be deployed/enabled.
 */
public data class SolutionPropertiesArgs(
    public val containedResources: Output<List<String>>? = null,
    public val referencedResources: Output<List<String>>? = null,
    public val workspaceResourceId: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.operationsmanagement.inputs.SolutionPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.operationsmanagement.inputs.SolutionPropertiesArgs =
        com.pulumi.azurenative.operationsmanagement.inputs.SolutionPropertiesArgs.builder()
            .containedResources(containedResources?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .referencedResources(referencedResources?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .workspaceResourceId(workspaceResourceId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SolutionPropertiesArgs].
 */
@PulumiTagMarker
public class SolutionPropertiesArgsBuilder internal constructor() {
    private var containedResources: Output<List<String>>? = null

    private var referencedResources: Output<List<String>>? = null

    private var workspaceResourceId: Output<String>? = null

    /**
     * @param value The azure resources that will be contained within the solutions. They will be locked and gets deleted automatically when the solution is deleted.
     */
    @JvmName("iofisnsmtygyoyps")
    public suspend fun containedResources(`value`: Output<List<String>>) {
        this.containedResources = value
    }

    @JvmName("duxxtwqpofxonlto")
    public suspend fun containedResources(vararg values: Output<String>) {
        this.containedResources = Output.all(values.asList())
    }

    /**
     * @param values The azure resources that will be contained within the solutions. They will be locked and gets deleted automatically when the solution is deleted.
     */
    @JvmName("ialydfssxdjqojxy")
    public suspend fun containedResources(values: List<Output<String>>) {
        this.containedResources = Output.all(values)
    }

    /**
     * @param value The resources that will be referenced from this solution. Deleting any of those solution out of band will break the solution.
     */
    @JvmName("ltbfumqntsljyifp")
    public suspend fun referencedResources(`value`: Output<List<String>>) {
        this.referencedResources = value
    }

    @JvmName("eaucsclorvtmihjb")
    public suspend fun referencedResources(vararg values: Output<String>) {
        this.referencedResources = Output.all(values.asList())
    }

    /**
     * @param values The resources that will be referenced from this solution. Deleting any of those solution out of band will break the solution.
     */
    @JvmName("axjyauiwfexipmjt")
    public suspend fun referencedResources(values: List<Output<String>>) {
        this.referencedResources = Output.all(values)
    }

    /**
     * @param value The azure resourceId for the workspace where the solution will be deployed/enabled.
     */
    @JvmName("uwfvfdwbxsbekgiw")
    public suspend fun workspaceResourceId(`value`: Output<String>) {
        this.workspaceResourceId = value
    }

    /**
     * @param value The azure resources that will be contained within the solutions. They will be locked and gets deleted automatically when the solution is deleted.
     */
    @JvmName("shnpdxwijwaqhwtp")
    public suspend fun containedResources(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containedResources = mapped
    }

    /**
     * @param values The azure resources that will be contained within the solutions. They will be locked and gets deleted automatically when the solution is deleted.
     */
    @JvmName("jciothhknfvoywmc")
    public suspend fun containedResources(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.containedResources = mapped
    }

    /**
     * @param value The resources that will be referenced from this solution. Deleting any of those solution out of band will break the solution.
     */
    @JvmName("ljsgokawrlrtafrb")
    public suspend fun referencedResources(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.referencedResources = mapped
    }

    /**
     * @param values The resources that will be referenced from this solution. Deleting any of those solution out of band will break the solution.
     */
    @JvmName("ntvyhadesmxannwb")
    public suspend fun referencedResources(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.referencedResources = mapped
    }

    /**
     * @param value The azure resourceId for the workspace where the solution will be deployed/enabled.
     */
    @JvmName("ilmknjkynoavnvjc")
    public suspend fun workspaceResourceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.workspaceResourceId = mapped
    }

    internal fun build(): SolutionPropertiesArgs = SolutionPropertiesArgs(
        containedResources = containedResources,
        referencedResources = referencedResources,
        workspaceResourceId = workspaceResourceId ?: throw PulumiNullFieldException("workspaceResourceId"),
    )
}
