@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationsmanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Parameter to pass to ARM template
 * @property name name of the parameter.
 * @property value value for the parameter. In Jtoken
 */
public data class ArmTemplateParameterResponse(
    public val name: String? = null,
    public val `value`: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.operationsmanagement.outputs.ArmTemplateParameterResponse): ArmTemplateParameterResponse = ArmTemplateParameterResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
