@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationsmanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * ManagementAssociation properties supported by the OperationsManagement resource provider.
 * @property applicationId The applicationId of the appliance for this association.
 */
public data class ManagementAssociationPropertiesResponse(
    public val applicationId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.operationsmanagement.outputs.ManagementAssociationPropertiesResponse): ManagementAssociationPropertiesResponse = ManagementAssociationPropertiesResponse(
            applicationId = javaType.applicationId(),
        )
    }
}
