@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationsmanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Plan for solution object supported by the OperationsManagement resource provider.
 * @property name name of the solution to be created. For Microsoft published solution it should be in the format of solutionType(workspaceName). SolutionType part is case sensitive. For third party solution, it can be anything.
 * @property product name of the solution to enabled/add. For Microsoft published gallery solution it should be in the format of OMSGallery/<solutionType>. This is case sensitive
 * @property promotionCode promotionCode, Not really used now, can you left as empty
 * @property publisher Publisher name. For gallery solution, it is Microsoft.
 */
public data class SolutionPlanResponse(
    public val name: String? = null,
    public val product: String? = null,
    public val promotionCode: String? = null,
    public val publisher: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.operationsmanagement.outputs.SolutionPlanResponse): SolutionPlanResponse = SolutionPlanResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            product = javaType.product().map({ args0 -> args0 }).orElse(null),
            promotionCode = javaType.promotionCode().map({ args0 -> args0 }).orElse(null),
            publisher = javaType.publisher().map({ args0 -> args0 }).orElse(null),
        )
    }
}
