@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationsmanagement.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Solution properties supported by the OperationsManagement resource provider.
 * @property containedResources The azure resources that will be contained within the solutions. They will be locked and gets deleted automatically when the solution is deleted.
 * @property provisioningState The provisioning state for the solution.
 * @property referencedResources The resources that will be referenced from this solution. Deleting any of those solution out of band will break the solution.
 * @property workspaceResourceId The azure resourceId for the workspace where the solution will be deployed/enabled.
 */
public data class SolutionPropertiesResponse(
    public val containedResources: List<String>? = null,
    public val provisioningState: String,
    public val referencedResources: List<String>? = null,
    public val workspaceResourceId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.operationsmanagement.outputs.SolutionPropertiesResponse): SolutionPropertiesResponse = SolutionPropertiesResponse(
            containedResources = javaType.containedResources().map({ args0 -> args0 }),
            provisioningState = javaType.provisioningState(),
            referencedResources = javaType.referencedResources().map({ args0 -> args0 }),
            workspaceResourceId = javaType.workspaceResourceId(),
        )
    }
}
