@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.orbital.kotlin

import com.pulumi.azurenative.orbital.EdgeSiteArgs.builder
import com.pulumi.azurenative.orbital.kotlin.inputs.EdgeSitesPropertiesGlobalCommunicationsSiteArgs
import com.pulumi.azurenative.orbital.kotlin.inputs.EdgeSitesPropertiesGlobalCommunicationsSiteArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A customer's reference to a global communications site site.
 * Azure REST API version: 2024-03-01-preview.
 * Other available API versions: 2024-03-01.
 * ## Example Usage
 * ### Create Edge Site
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var edgeSite = new AzureNative.Orbital.EdgeSite("edgeSite", new()
 *     {
 *         EdgeSiteName = "es1",
 *         GlobalCommunicationsSite = new AzureNative.Orbital.Inputs.EdgeSitesPropertiesGlobalCommunicationsSiteArgs
 *         {
 *             Id = "/subscriptions/c1be1141-a7c9-4aac-9608-3c2e2f1152c3/providers/Microsoft.Orbital/globalCommunicationsSites/contoso-Vernon",
 *         },
 *         Location = "westus",
 *         ResourceGroupName = "rg1",
 *         Tags =
 *         {
 *             { "tag1", "value1" },
 *             { "tag2", "value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/orbital/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := orbital.NewEdgeSite(ctx, "edgeSite", &orbital.EdgeSiteArgs{
 * 			EdgeSiteName: pulumi.String("es1"),
 * 			GlobalCommunicationsSite: &orbital.EdgeSitesPropertiesGlobalCommunicationsSiteArgs{
 * 				Id: pulumi.String("/subscriptions/c1be1141-a7c9-4aac-9608-3c2e2f1152c3/providers/Microsoft.Orbital/globalCommunicationsSites/contoso-Vernon"),
 * 			},
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Tags: pulumi.StringMap{
 * 				"tag1": pulumi.String("value1"),
 * 				"tag2": pulumi.String("value2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.orbital.EdgeSite;
 * import com.pulumi.azurenative.orbital.EdgeSiteArgs;
 * import com.pulumi.azurenative.orbital.inputs.EdgeSitesPropertiesGlobalCommunicationsSiteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var edgeSite = new EdgeSite("edgeSite", EdgeSiteArgs.builder()
 *             .edgeSiteName("es1")
 *             .globalCommunicationsSite(EdgeSitesPropertiesGlobalCommunicationsSiteArgs.builder()
 *                 .id("/subscriptions/c1be1141-a7c9-4aac-9608-3c2e2f1152c3/providers/Microsoft.Orbital/globalCommunicationsSites/contoso-Vernon")
 *                 .build())
 *             .location("westus")
 *             .resourceGroupName("rg1")
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "value1"),
 *                 Map.entry("tag2", "value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:orbital:EdgeSite es1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Orbital/edgeSites/{edgeSiteName}
 * ```
 * @property edgeSiteName Edge site name.
 * @property globalCommunicationsSite A reference to global communications site.
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class EdgeSiteArgs(
    public val edgeSiteName: Output<String>? = null,
    public val globalCommunicationsSite: Output<EdgeSitesPropertiesGlobalCommunicationsSiteArgs>? =
        null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.orbital.EdgeSiteArgs> {
    override fun toJava(): com.pulumi.azurenative.orbital.EdgeSiteArgs =
        com.pulumi.azurenative.orbital.EdgeSiteArgs.builder()
            .edgeSiteName(edgeSiteName?.applyValue({ args0 -> args0 }))
            .globalCommunicationsSite(
                globalCommunicationsSite?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [EdgeSiteArgs].
 */
@PulumiTagMarker
public class EdgeSiteArgsBuilder internal constructor() {
    private var edgeSiteName: Output<String>? = null

    private var globalCommunicationsSite: Output<EdgeSitesPropertiesGlobalCommunicationsSiteArgs>? =
        null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Edge site name.
     */
    @JvmName("bduebnimlnmbrebr")
    public suspend fun edgeSiteName(`value`: Output<String>) {
        this.edgeSiteName = value
    }

    /**
     * @param value A reference to global communications site.
     */
    @JvmName("ecwcgmlxhskgwspo")
    public suspend fun globalCommunicationsSite(`value`: Output<EdgeSitesPropertiesGlobalCommunicationsSiteArgs>) {
        this.globalCommunicationsSite = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("oljphjinwdntynur")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("johebkeuiftymstt")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("wugrbbnvlskjeqnn")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Edge site name.
     */
    @JvmName("wwaghleslbjilacy")
    public suspend fun edgeSiteName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.edgeSiteName = mapped
    }

    /**
     * @param value A reference to global communications site.
     */
    @JvmName("qjhioaydmpeywlqg")
    public suspend fun globalCommunicationsSite(`value`: EdgeSitesPropertiesGlobalCommunicationsSiteArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.globalCommunicationsSite = mapped
    }

    /**
     * @param argument A reference to global communications site.
     */
    @JvmName("bwwyfkgfmblvdiua")
    public suspend fun globalCommunicationsSite(argument: suspend EdgeSitesPropertiesGlobalCommunicationsSiteArgsBuilder.() -> Unit) {
        val toBeMapped = EdgeSitesPropertiesGlobalCommunicationsSiteArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.globalCommunicationsSite = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("uoddxdxueydnndwk")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("leryhvlaxlbegkha")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ekqjcpfgkurulppt")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("gelrvirrreqfjijy")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): EdgeSiteArgs = EdgeSiteArgs(
        edgeSiteName = edgeSiteName,
        globalCommunicationsSite = globalCommunicationsSite,
        location = location,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
