@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.orbital.kotlin

import com.pulumi.azurenative.orbital.kotlin.outputs.L2ConnectionsPropertiesResponseEdgeSite
import com.pulumi.azurenative.orbital.kotlin.outputs.L2ConnectionsPropertiesResponseGroundStation
import com.pulumi.azurenative.orbital.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.orbital.kotlin.outputs.L2ConnectionsPropertiesResponseEdgeSite.Companion.toKotlin as l2ConnectionsPropertiesResponseEdgeSiteToKotlin
import com.pulumi.azurenative.orbital.kotlin.outputs.L2ConnectionsPropertiesResponseGroundStation.Companion.toKotlin as l2ConnectionsPropertiesResponseGroundStationToKotlin
import com.pulumi.azurenative.orbital.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [L2Connection].
 */
@PulumiTagMarker
public class L2ConnectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: L2ConnectionArgs = L2ConnectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend L2ConnectionArgsBuilder.() -> Unit) {
        val builder = L2ConnectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): L2Connection {
        val builtJavaResource = com.pulumi.azurenative.orbital.L2Connection(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return L2Connection(builtJavaResource)
    }
}

/**
 * Connects an edge site to an orbital gateway and describes what layer 2 traffic to forward between them.
 * Azure REST API version: 2024-03-01-preview.
 * Other available API versions: 2024-03-01.
 * ## Example Usage
 * ### Create L2 Connection
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var l2Connection = new AzureNative.Orbital.L2Connection("l2Connection", new()
 *     {
 *         EdgeSite = new AzureNative.Orbital.Inputs.L2ConnectionsPropertiesEdgeSiteArgs
 *         {
 *             Id = "/subscriptions/c1be1141-a7c9-4aac-9608-3c2e2f1152c3/resourceGroups/rg1/providers/Microsoft.Orbital/edgeSites/es1",
 *         },
 *         GroundStation = new AzureNative.Orbital.Inputs.L2ConnectionsPropertiesGroundStationArgs
 *         {
 *             Id = "/subscriptions/c1be1141-a7c9-4aac-9608-3c2e2f1152c3/resourceGroups/rg1/providers/Microsoft.Orbital/groundStations/gs1",
 *         },
 *         L2ConnectionName = "connection1",
 *         Location = "westus",
 *         Name = "customerName-SiteName-01",
 *         ResourceGroupName = "rg1",
 *         Tags =
 *         {
 *             { "tag1", "value1" },
 *             { "tag2", "value2" },
 *         },
 *         VlanId = 200,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/orbital/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := orbital.NewL2Connection(ctx, "l2Connection", &orbital.L2ConnectionArgs{
 * 			EdgeSite: &orbital.L2ConnectionsPropertiesEdgeSiteArgs{
 * 				Id: pulumi.String("/subscriptions/c1be1141-a7c9-4aac-9608-3c2e2f1152c3/resourceGroups/rg1/providers/Microsoft.Orbital/edgeSites/es1"),
 * 			},
 * 			GroundStation: &orbital.L2ConnectionsPropertiesGroundStationArgs{
 * 				Id: pulumi.String("/subscriptions/c1be1141-a7c9-4aac-9608-3c2e2f1152c3/resourceGroups/rg1/providers/Microsoft.Orbital/groundStations/gs1"),
 * 			},
 * 			L2ConnectionName:  pulumi.String("connection1"),
 * 			Location:          pulumi.String("westus"),
 * 			Name:              pulumi.String("customerName-SiteName-01"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Tags: pulumi.StringMap{
 * 				"tag1": pulumi.String("value1"),
 * 				"tag2": pulumi.String("value2"),
 * 			},
 * 			VlanId: pulumi.Int(200),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.orbital.L2Connection;
 * import com.pulumi.azurenative.orbital.L2ConnectionArgs;
 * import com.pulumi.azurenative.orbital.inputs.L2ConnectionsPropertiesEdgeSiteArgs;
 * import com.pulumi.azurenative.orbital.inputs.L2ConnectionsPropertiesGroundStationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var l2Connection = new L2Connection("l2Connection", L2ConnectionArgs.builder()
 *             .edgeSite(L2ConnectionsPropertiesEdgeSiteArgs.builder()
 *                 .id("/subscriptions/c1be1141-a7c9-4aac-9608-3c2e2f1152c3/resourceGroups/rg1/providers/Microsoft.Orbital/edgeSites/es1")
 *                 .build())
 *             .groundStation(L2ConnectionsPropertiesGroundStationArgs.builder()
 *                 .id("/subscriptions/c1be1141-a7c9-4aac-9608-3c2e2f1152c3/resourceGroups/rg1/providers/Microsoft.Orbital/groundStations/gs1")
 *                 .build())
 *             .l2ConnectionName("connection1")
 *             .location("westus")
 *             .name("customerName-SiteName-01")
 *             .resourceGroupName("rg1")
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "value1"),
 *                 Map.entry("tag2", "value2")
 *             ))
 *             .vlanId(200)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:orbital:L2Connection connection1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Orbital/l2Connections/{l2ConnectionName}
 * ```
 */
public class L2Connection internal constructor(
    override val javaResource: com.pulumi.azurenative.orbital.L2Connection,
) : KotlinCustomResource(javaResource, L2ConnectionMapper) {
    /**
     * Globally-unique identifier for this connection that is to be used as a circuit ID.
     */
    public val circuitId: Output<String>
        get() = javaResource.circuitId().applyValue({ args0 -> args0 })

    /**
     * A reference to an Microsoft.Orbital/edgeSites resource to route traffic for.
     */
    public val edgeSite: Output<L2ConnectionsPropertiesResponseEdgeSite>
        get() = javaResource.edgeSite().applyValue({ args0 ->
            args0.let({ args0 ->
                l2ConnectionsPropertiesResponseEdgeSiteToKotlin(args0)
            })
        })

    /**
     * A reference to an Microsoft.Orbital/groundStations resource to route traffic for.
     */
    public val groundStation: Output<L2ConnectionsPropertiesResponseGroundStation>
        get() = javaResource.groundStation().applyValue({ args0 ->
            args0.let({ args0 ->
                l2ConnectionsPropertiesResponseGroundStationToKotlin(args0)
            })
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The VLAN ID for the L2 connection.
     */
    public val vlanId: Output<Int>
        get() = javaResource.vlanId().applyValue({ args0 -> args0 })
}

public object L2ConnectionMapper : ResourceMapper<L2Connection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.orbital.L2Connection::class == javaResource::class

    override fun map(javaResource: Resource): L2Connection = L2Connection(
        javaResource as
            com.pulumi.azurenative.orbital.L2Connection,
    )
}

/**
 * @see [L2Connection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [L2Connection].
 */
public suspend fun l2Connection(
    name: String,
    block: suspend L2ConnectionResourceBuilder.() -> Unit,
): L2Connection {
    val builder = L2ConnectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [L2Connection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun l2Connection(name: String): L2Connection {
    val builder = L2ConnectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
