@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.orbital.kotlin

import com.pulumi.azurenative.orbital.L2ConnectionArgs.builder
import com.pulumi.azurenative.orbital.kotlin.inputs.L2ConnectionsPropertiesEdgeSiteArgs
import com.pulumi.azurenative.orbital.kotlin.inputs.L2ConnectionsPropertiesEdgeSiteArgsBuilder
import com.pulumi.azurenative.orbital.kotlin.inputs.L2ConnectionsPropertiesGroundStationArgs
import com.pulumi.azurenative.orbital.kotlin.inputs.L2ConnectionsPropertiesGroundStationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Connects an edge site to an orbital gateway and describes what layer 2 traffic to forward between them.
 * Azure REST API version: 2024-03-01-preview.
 * Other available API versions: 2024-03-01.
 * ## Example Usage
 * ### Create L2 Connection
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var l2Connection = new AzureNative.Orbital.L2Connection("l2Connection", new()
 *     {
 *         EdgeSite = new AzureNative.Orbital.Inputs.L2ConnectionsPropertiesEdgeSiteArgs
 *         {
 *             Id = "/subscriptions/c1be1141-a7c9-4aac-9608-3c2e2f1152c3/resourceGroups/rg1/providers/Microsoft.Orbital/edgeSites/es1",
 *         },
 *         GroundStation = new AzureNative.Orbital.Inputs.L2ConnectionsPropertiesGroundStationArgs
 *         {
 *             Id = "/subscriptions/c1be1141-a7c9-4aac-9608-3c2e2f1152c3/resourceGroups/rg1/providers/Microsoft.Orbital/groundStations/gs1",
 *         },
 *         L2ConnectionName = "connection1",
 *         Location = "westus",
 *         Name = "customerName-SiteName-01",
 *         ResourceGroupName = "rg1",
 *         Tags =
 *         {
 *             { "tag1", "value1" },
 *             { "tag2", "value2" },
 *         },
 *         VlanId = 200,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/orbital/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := orbital.NewL2Connection(ctx, "l2Connection", &orbital.L2ConnectionArgs{
 * 			EdgeSite: &orbital.L2ConnectionsPropertiesEdgeSiteArgs{
 * 				Id: pulumi.String("/subscriptions/c1be1141-a7c9-4aac-9608-3c2e2f1152c3/resourceGroups/rg1/providers/Microsoft.Orbital/edgeSites/es1"),
 * 			},
 * 			GroundStation: &orbital.L2ConnectionsPropertiesGroundStationArgs{
 * 				Id: pulumi.String("/subscriptions/c1be1141-a7c9-4aac-9608-3c2e2f1152c3/resourceGroups/rg1/providers/Microsoft.Orbital/groundStations/gs1"),
 * 			},
 * 			L2ConnectionName:  pulumi.String("connection1"),
 * 			Location:          pulumi.String("westus"),
 * 			Name:              pulumi.String("customerName-SiteName-01"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Tags: pulumi.StringMap{
 * 				"tag1": pulumi.String("value1"),
 * 				"tag2": pulumi.String("value2"),
 * 			},
 * 			VlanId: pulumi.Int(200),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.orbital.L2Connection;
 * import com.pulumi.azurenative.orbital.L2ConnectionArgs;
 * import com.pulumi.azurenative.orbital.inputs.L2ConnectionsPropertiesEdgeSiteArgs;
 * import com.pulumi.azurenative.orbital.inputs.L2ConnectionsPropertiesGroundStationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var l2Connection = new L2Connection("l2Connection", L2ConnectionArgs.builder()
 *             .edgeSite(L2ConnectionsPropertiesEdgeSiteArgs.builder()
 *                 .id("/subscriptions/c1be1141-a7c9-4aac-9608-3c2e2f1152c3/resourceGroups/rg1/providers/Microsoft.Orbital/edgeSites/es1")
 *                 .build())
 *             .groundStation(L2ConnectionsPropertiesGroundStationArgs.builder()
 *                 .id("/subscriptions/c1be1141-a7c9-4aac-9608-3c2e2f1152c3/resourceGroups/rg1/providers/Microsoft.Orbital/groundStations/gs1")
 *                 .build())
 *             .l2ConnectionName("connection1")
 *             .location("westus")
 *             .name("customerName-SiteName-01")
 *             .resourceGroupName("rg1")
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "value1"),
 *                 Map.entry("tag2", "value2")
 *             ))
 *             .vlanId(200)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:orbital:L2Connection connection1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Orbital/l2Connections/{l2ConnectionName}
 * ```
 * @property edgeSite A reference to an Microsoft.Orbital/edgeSites resource to route traffic for.
 * @property groundStation A reference to an Microsoft.Orbital/groundStations resource to route traffic for.
 * @property l2ConnectionName L2 Connection name.
 * @property location The geo-location where the resource lives
 * @property name The unique name of the partner router that cross-connects with the Orbital Edge Router at the ground station site.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 * @property vlanId The VLAN ID for the L2 connection.
 */
public data class L2ConnectionArgs(
    public val edgeSite: Output<L2ConnectionsPropertiesEdgeSiteArgs>? = null,
    public val groundStation: Output<L2ConnectionsPropertiesGroundStationArgs>? = null,
    public val l2ConnectionName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vlanId: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.orbital.L2ConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.orbital.L2ConnectionArgs =
        com.pulumi.azurenative.orbital.L2ConnectionArgs.builder()
            .edgeSite(edgeSite?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .groundStation(groundStation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .l2ConnectionName(l2ConnectionName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vlanId(vlanId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [L2ConnectionArgs].
 */
@PulumiTagMarker
public class L2ConnectionArgsBuilder internal constructor() {
    private var edgeSite: Output<L2ConnectionsPropertiesEdgeSiteArgs>? = null

    private var groundStation: Output<L2ConnectionsPropertiesGroundStationArgs>? = null

    private var l2ConnectionName: Output<String>? = null

    private var location: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vlanId: Output<Int>? = null

    /**
     * @param value A reference to an Microsoft.Orbital/edgeSites resource to route traffic for.
     */
    @JvmName("nsuqcxoabcupegwa")
    public suspend fun edgeSite(`value`: Output<L2ConnectionsPropertiesEdgeSiteArgs>) {
        this.edgeSite = value
    }

    /**
     * @param value A reference to an Microsoft.Orbital/groundStations resource to route traffic for.
     */
    @JvmName("cafyubxmkqpjmrfd")
    public suspend fun groundStation(`value`: Output<L2ConnectionsPropertiesGroundStationArgs>) {
        this.groundStation = value
    }

    /**
     * @param value L2 Connection name.
     */
    @JvmName("tymfffapmfqosige")
    public suspend fun l2ConnectionName(`value`: Output<String>) {
        this.l2ConnectionName = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ttarlqgnrahaoiss")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The unique name of the partner router that cross-connects with the Orbital Edge Router at the ground station site.
     */
    @JvmName("dectfvrpbpxuitsk")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("bnvbihxiqljcgfks")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("nwrypocuyiprfdcd")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The VLAN ID for the L2 connection.
     */
    @JvmName("jkfetnucggsrldtu")
    public suspend fun vlanId(`value`: Output<Int>) {
        this.vlanId = value
    }

    /**
     * @param value A reference to an Microsoft.Orbital/edgeSites resource to route traffic for.
     */
    @JvmName("dbexrogpndgdctph")
    public suspend fun edgeSite(`value`: L2ConnectionsPropertiesEdgeSiteArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.edgeSite = mapped
    }

    /**
     * @param argument A reference to an Microsoft.Orbital/edgeSites resource to route traffic for.
     */
    @JvmName("gifwcipuelbnagry")
    public suspend fun edgeSite(argument: suspend L2ConnectionsPropertiesEdgeSiteArgsBuilder.() -> Unit) {
        val toBeMapped = L2ConnectionsPropertiesEdgeSiteArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.edgeSite = mapped
    }

    /**
     * @param value A reference to an Microsoft.Orbital/groundStations resource to route traffic for.
     */
    @JvmName("bjqrfqkejjlskigt")
    public suspend fun groundStation(`value`: L2ConnectionsPropertiesGroundStationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groundStation = mapped
    }

    /**
     * @param argument A reference to an Microsoft.Orbital/groundStations resource to route traffic for.
     */
    @JvmName("gsobvbtbrmmdptba")
    public suspend fun groundStation(argument: suspend L2ConnectionsPropertiesGroundStationArgsBuilder.() -> Unit) {
        val toBeMapped = L2ConnectionsPropertiesGroundStationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.groundStation = mapped
    }

    /**
     * @param value L2 Connection name.
     */
    @JvmName("ghjralsrbeygdlfp")
    public suspend fun l2ConnectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.l2ConnectionName = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("eyinqtkqenbjykpb")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The unique name of the partner router that cross-connects with the Orbital Edge Router at the ground station site.
     */
    @JvmName("aduftwmdafbwbmkx")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("kkoxwdewmtbqvvrj")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("qlwvuucoqaebldpr")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("evmhgypybbvmmivi")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The VLAN ID for the L2 connection.
     */
    @JvmName("rsfyvguntmfkdkyj")
    public suspend fun vlanId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vlanId = mapped
    }

    internal fun build(): L2ConnectionArgs = L2ConnectionArgs(
        edgeSite = edgeSite,
        groundStation = groundStation,
        l2ConnectionName = l2ConnectionName,
        location = location,
        name = name,
        resourceGroupName = resourceGroupName,
        tags = tags,
        vlanId = vlanId,
    )
}
