@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.orbital.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Polarization. e.g. (RHCP, LHCP).
 */
public enum class Polarization(
    public val javaValue: com.pulumi.azurenative.orbital.enums.Polarization,
) : ConvertibleToJava<com.pulumi.azurenative.orbital.enums.Polarization> {
    RHCP(com.pulumi.azurenative.orbital.enums.Polarization.RHCP),
    LHCP(com.pulumi.azurenative.orbital.enums.Polarization.LHCP),
    LinearVertical(com.pulumi.azurenative.orbital.enums.Polarization.LinearVertical),
    LinearHorizontal(com.pulumi.azurenative.orbital.enums.Polarization.LinearHorizontal),
    ;

    override fun toJava(): com.pulumi.azurenative.orbital.enums.Polarization = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.orbital.enums.Polarization): Polarization =
            Polarization.values().first { it.javaValue == javaType }
    }
}
