@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.orbital.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Protocol either UDP or TCP.
 */
public enum class Protocol(
    public val javaValue: com.pulumi.azurenative.orbital.enums.Protocol,
) : ConvertibleToJava<com.pulumi.azurenative.orbital.enums.Protocol> {
    TCP(com.pulumi.azurenative.orbital.enums.Protocol.TCP),
    UDP(com.pulumi.azurenative.orbital.enums.Protocol.UDP),
    ;

    override fun toJava(): com.pulumi.azurenative.orbital.enums.Protocol = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.orbital.enums.Protocol): Protocol =
            Protocol.values().first { it.javaValue == javaType }
    }
}
