@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.orbital.kotlin.inputs

import com.pulumi.azurenative.orbital.inputs.GetSpacecraftPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property spacecraftName Spacecraft ID.
 */
public data class GetSpacecraftPlainArgs(
    public val resourceGroupName: String,
    public val spacecraftName: String,
) : ConvertibleToJava<com.pulumi.azurenative.orbital.inputs.GetSpacecraftPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.orbital.inputs.GetSpacecraftPlainArgs =
        com.pulumi.azurenative.orbital.inputs.GetSpacecraftPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .spacecraftName(spacecraftName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSpacecraftPlainArgs].
 */
@PulumiTagMarker
public class GetSpacecraftPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var spacecraftName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("yhflqycsfmakwcdd")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Spacecraft ID.
     */
    @JvmName("vggwmappbvmiqxjk")
    public suspend fun spacecraftName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.spacecraftName = mapped
    }

    internal fun build(): GetSpacecraftPlainArgs = GetSpacecraftPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        spacecraftName = spacecraftName ?: throw PulumiNullFieldException("spacecraftName"),
    )
}
