@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.orbital.kotlin.inputs

import com.pulumi.azurenative.orbital.inputs.GroundStationsPropertiesGlobalCommunicationsSiteArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A reference to global communications site.
 * @property id Resource ID.
 */
public data class GroundStationsPropertiesGlobalCommunicationsSiteArgs(
    public val id: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.orbital.inputs.GroundStationsPropertiesGlobalCommunicationsSiteArgs> {
    override fun toJava(): com.pulumi.azurenative.orbital.inputs.GroundStationsPropertiesGlobalCommunicationsSiteArgs =
        com.pulumi.azurenative.orbital.inputs.GroundStationsPropertiesGlobalCommunicationsSiteArgs.builder()
            .id(id.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GroundStationsPropertiesGlobalCommunicationsSiteArgs].
 */
@PulumiTagMarker
public class GroundStationsPropertiesGlobalCommunicationsSiteArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value Resource ID.
     */
    @JvmName("iuwfuxickjborqtk")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("decfxbbhadliwito")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): GroundStationsPropertiesGlobalCommunicationsSiteArgs =
        GroundStationsPropertiesGlobalCommunicationsSiteArgs(
            id = id ?: throw PulumiNullFieldException("id"),
        )
}
