@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.orbital.kotlin.inputs

import com.pulumi.azurenative.orbital.inputs.ListGroundStationL2ConnectionsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property groundStationName Ground Station name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class ListGroundStationL2ConnectionsPlainArgs(
    public val groundStationName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.orbital.inputs.ListGroundStationL2ConnectionsPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.orbital.inputs.ListGroundStationL2ConnectionsPlainArgs =
        com.pulumi.azurenative.orbital.inputs.ListGroundStationL2ConnectionsPlainArgs.builder()
            .groundStationName(groundStationName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListGroundStationL2ConnectionsPlainArgs].
 */
@PulumiTagMarker
public class ListGroundStationL2ConnectionsPlainArgsBuilder internal constructor() {
    private var groundStationName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Ground Station name.
     */
    @JvmName("aiwxsgmixvocbpwy")
    public suspend fun groundStationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.groundStationName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hpafnqoavmmmnwbw")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): ListGroundStationL2ConnectionsPlainArgs =
        ListGroundStationL2ConnectionsPlainArgs(
            groundStationName = groundStationName ?: throw PulumiNullFieldException("groundStationName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
