@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.orbital.kotlin.inputs

import com.pulumi.azurenative.orbital.inputs.SpacecraftLinkArgs.builder
import com.pulumi.azurenative.orbital.kotlin.enums.Direction
import com.pulumi.azurenative.orbital.kotlin.enums.Polarization
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * List of authorized spacecraft links per ground station and the expiration date of the authorization.
 * @property bandwidthMHz Bandwidth in MHz.
 * @property centerFrequencyMHz Center Frequency in MHz.
 * @property direction Direction (Uplink or Downlink).
 * @property name Link name.
 * @property polarization Polarization. e.g. (RHCP, LHCP).
 */
public data class SpacecraftLinkArgs(
    public val bandwidthMHz: Output<Double>,
    public val centerFrequencyMHz: Output<Double>,
    public val direction: Output<Either<String, Direction>>,
    public val name: Output<String>,
    public val polarization: Output<Either<String, Polarization>>,
) : ConvertibleToJava<com.pulumi.azurenative.orbital.inputs.SpacecraftLinkArgs> {
    override fun toJava(): com.pulumi.azurenative.orbital.inputs.SpacecraftLinkArgs =
        com.pulumi.azurenative.orbital.inputs.SpacecraftLinkArgs.builder()
            .bandwidthMHz(bandwidthMHz.applyValue({ args0 -> args0 }))
            .centerFrequencyMHz(centerFrequencyMHz.applyValue({ args0 -> args0 }))
            .direction(
                direction.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .name(name.applyValue({ args0 -> args0 }))
            .polarization(
                polarization.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [SpacecraftLinkArgs].
 */
@PulumiTagMarker
public class SpacecraftLinkArgsBuilder internal constructor() {
    private var bandwidthMHz: Output<Double>? = null

    private var centerFrequencyMHz: Output<Double>? = null

    private var direction: Output<Either<String, Direction>>? = null

    private var name: Output<String>? = null

    private var polarization: Output<Either<String, Polarization>>? = null

    /**
     * @param value Bandwidth in MHz.
     */
    @JvmName("dxephibbhdtvhkhq")
    public suspend fun bandwidthMHz(`value`: Output<Double>) {
        this.bandwidthMHz = value
    }

    /**
     * @param value Center Frequency in MHz.
     */
    @JvmName("piomcikgdaogaful")
    public suspend fun centerFrequencyMHz(`value`: Output<Double>) {
        this.centerFrequencyMHz = value
    }

    /**
     * @param value Direction (Uplink or Downlink).
     */
    @JvmName("rkcnloqkebsdxkli")
    public suspend fun direction(`value`: Output<Either<String, Direction>>) {
        this.direction = value
    }

    /**
     * @param value Link name.
     */
    @JvmName("dkflnedlctbxlspd")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Polarization. e.g. (RHCP, LHCP).
     */
    @JvmName("lbxsppbfqaciblxf")
    public suspend fun polarization(`value`: Output<Either<String, Polarization>>) {
        this.polarization = value
    }

    /**
     * @param value Bandwidth in MHz.
     */
    @JvmName("jboqrgobywlaypml")
    public suspend fun bandwidthMHz(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bandwidthMHz = mapped
    }

    /**
     * @param value Center Frequency in MHz.
     */
    @JvmName("smwwfpefhtuvqwhm")
    public suspend fun centerFrequencyMHz(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.centerFrequencyMHz = mapped
    }

    /**
     * @param value Direction (Uplink or Downlink).
     */
    @JvmName("cjikqgmxiybrhptj")
    public suspend fun direction(`value`: Either<String, Direction>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.direction = mapped
    }

    /**
     * @param value Direction (Uplink or Downlink).
     */
    @JvmName("ggknejyiyarvgxhr")
    public fun direction(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Direction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.direction = mapped
    }

    /**
     * @param value Direction (Uplink or Downlink).
     */
    @JvmName("vgtdrnnncunnyaeu")
    public fun direction(`value`: Direction) {
        val toBeMapped = Either.ofRight<String, Direction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.direction = mapped
    }

    /**
     * @param value Link name.
     */
    @JvmName("lsmfjkkltxxkaryf")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Polarization. e.g. (RHCP, LHCP).
     */
    @JvmName("esaqpvsfdkjqpksn")
    public suspend fun polarization(`value`: Either<String, Polarization>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.polarization = mapped
    }

    /**
     * @param value Polarization. e.g. (RHCP, LHCP).
     */
    @JvmName("grbsgtlpjputocdi")
    public fun polarization(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Polarization>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.polarization = mapped
    }

    /**
     * @param value Polarization. e.g. (RHCP, LHCP).
     */
    @JvmName("wohcmmvrjqeucgog")
    public fun polarization(`value`: Polarization) {
        val toBeMapped = Either.ofRight<String, Polarization>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.polarization = mapped
    }

    internal fun build(): SpacecraftLinkArgs = SpacecraftLinkArgs(
        bandwidthMHz = bandwidthMHz ?: throw PulumiNullFieldException("bandwidthMHz"),
        centerFrequencyMHz = centerFrequencyMHz ?: throw PulumiNullFieldException("centerFrequencyMHz"),
        direction = direction ?: throw PulumiNullFieldException("direction"),
        name = name ?: throw PulumiNullFieldException("name"),
        polarization = polarization ?: throw PulumiNullFieldException("polarization"),
    )
}
