@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.orbital.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Authorized groundstation.
 * @property expirationDate Date of authorization expiration.
 * @property groundStation Groundstation name.
 */
public data class AuthorizedGroundstationResponse(
    public val expirationDate: String,
    public val groundStation: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.orbital.outputs.AuthorizedGroundstationResponse): AuthorizedGroundstationResponse = AuthorizedGroundstationResponse(
            expirationDate = javaType.expirationDate(),
            groundStation = javaType.groundStation(),
        )
    }
}
