@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.orbital.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Customer retrieves list of Available Contacts for a spacecraft resource. Later, one of the available contact can be selected to create a contact.
 * @property endAzimuthDegrees Azimuth of the antenna at the end of the contact in decimal degrees.
 * @property endElevationDegrees Spacecraft elevation above the horizon at contact end.
 * @property groundStationName Name of Azure Ground Station.
 * @property maximumElevationDegrees Maximum elevation of the antenna during the contact in decimal degrees.
 * @property rxEndTime Time to lost receiving a signal (ISO 8601 UTC standard).
 * @property rxStartTime Earliest time to receive a signal (ISO 8601 UTC standard).
 * @property spacecraft The reference to the spacecraft resource.
 * @property startAzimuthDegrees Azimuth of the antenna at the start of the contact in decimal degrees.
 * @property startElevationDegrees Spacecraft elevation above the horizon at contact start.
 * @property txEndTime Time at which antenna transmit will be disabled (ISO 8601 UTC standard).
 * @property txStartTime Time at which antenna transmit will be enabled (ISO 8601 UTC standard).
 */
public data class AvailableContactsResponse(
    public val endAzimuthDegrees: Double,
    public val endElevationDegrees: Double,
    public val groundStationName: String,
    public val maximumElevationDegrees: Double,
    public val rxEndTime: String,
    public val rxStartTime: String,
    public val spacecraft: AvailableContactsResponseSpacecraft? = null,
    public val startAzimuthDegrees: Double,
    public val startElevationDegrees: Double,
    public val txEndTime: String,
    public val txStartTime: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.orbital.outputs.AvailableContactsResponse): AvailableContactsResponse = AvailableContactsResponse(
            endAzimuthDegrees = javaType.endAzimuthDegrees(),
            endElevationDegrees = javaType.endElevationDegrees(),
            groundStationName = javaType.groundStationName(),
            maximumElevationDegrees = javaType.maximumElevationDegrees(),
            rxEndTime = javaType.rxEndTime(),
            rxStartTime = javaType.rxStartTime(),
            spacecraft = javaType.spacecraft().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.orbital.kotlin.outputs.AvailableContactsResponseSpacecraft.Companion.toKotlin(args0)
                })
            }).orElse(null),
            startAzimuthDegrees = javaType.startAzimuthDegrees(),
            startElevationDegrees = javaType.startElevationDegrees(),
            txEndTime = javaType.txEndTime(),
            txStartTime = javaType.txStartTime(),
        )
    }
}
