@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.orbital.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Contact Profile third-party partner configuration.
 * @property missionConfiguration Name of string referencing the configuration describing contact set-up for a particular mission. Expected values are those which have been created in collaboration with the partner network.
 * @property providerName Name of the third-party provider.
 */
public data class ContactProfileThirdPartyConfigurationResponse(
    public val missionConfiguration: String,
    public val providerName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.orbital.outputs.ContactProfileThirdPartyConfigurationResponse): ContactProfileThirdPartyConfigurationResponse =
            ContactProfileThirdPartyConfigurationResponse(
                missionConfiguration = javaType.missionConfiguration(),
                providerName = javaType.providerName(),
            )
    }
}
