@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.orbital.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Network configuration of customer virtual network.
 * @property subnetId ARM resource identifier of the subnet delegated to the Microsoft.Orbital/orbitalGateways. Needs to be at least a class C subnet, and should not have any IP created in it.
 */
public data class ContactProfilesPropertiesResponseNetworkConfiguration(
    public val subnetId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.orbital.outputs.ContactProfilesPropertiesResponseNetworkConfiguration): ContactProfilesPropertiesResponseNetworkConfiguration =
            ContactProfilesPropertiesResponseNetworkConfiguration(
                subnetId = javaType.subnetId(),
            )
    }
}
