@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.orbital.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The configuration associated with the allocated antenna.
 * @property destinationIp The destination IP a packet can be sent to. This would for example be the TCP endpoint you would send data to.
 * @property sourceIps List of Source IP
 */
public data class ContactsPropertiesResponseAntennaConfiguration(
    public val destinationIp: String? = null,
    public val sourceIps: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.orbital.outputs.ContactsPropertiesResponseAntennaConfiguration): ContactsPropertiesResponseAntennaConfiguration =
            ContactsPropertiesResponseAntennaConfiguration(
                destinationIp = javaType.destinationIp().map({ args0 -> args0 }).orElse(null),
                sourceIps = javaType.sourceIps().map({ args0 -> args0 }),
            )
    }
}
