@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.orbital.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Customer end point to store and retrieve data during a contact with the spacecraft.
 * @property endPointName Name of an end point.
 * @property ipAddress IP Address (IPv4).
 * @property port TCP port to listen on to receive data.
 * @property protocol Protocol either UDP or TCP.
 */
public data class EndPointResponse(
    public val endPointName: String,
    public val ipAddress: String,
    public val port: String,
    public val protocol: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.orbital.outputs.EndPointResponse): EndPointResponse = EndPointResponse(
            endPointName = javaType.endPointName(),
            ipAddress = javaType.ipAddress(),
            port = javaType.port(),
            protocol = javaType.protocol(),
        )
    }
}
