@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.orbital.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Customer creates a contact resource for a spacecraft resource.
 * @property antennaConfiguration The configuration associated with the allocated antenna.
 * @property contactProfile The reference to the contact profile resource.
 * @property endAzimuthDegrees Azimuth of the antenna at the end of the contact in decimal degrees.
 * @property endElevationDegrees Spacecraft elevation above the horizon at contact end.
 * @property errorMessage Any error message while scheduling a contact.
 * @property groundStationName Azure Ground Station name.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property maximumElevationDegrees Maximum elevation of the antenna during the contact in decimal degrees.
 * @property name The name of the resource
 * @property reservationEndTime Reservation end time of a contact (ISO 8601 UTC standard).
 * @property reservationStartTime Reservation start time of a contact (ISO 8601 UTC standard).
 * @property rxEndTime Receive end time of a contact (ISO 8601 UTC standard).
 * @property rxStartTime Receive start time of a contact (ISO 8601 UTC standard).
 * @property startAzimuthDegrees Azimuth of the antenna at the start of the contact in decimal degrees.
 * @property startElevationDegrees Spacecraft elevation above the horizon at contact start.
 * @property status Status of a contact.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property txEndTime Transmit end time of a contact (ISO 8601 UTC standard).
 * @property txStartTime Transmit start time of a contact (ISO 8601 UTC standard).
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetContactResult(
    public val antennaConfiguration: ContactsPropertiesResponseAntennaConfiguration,
    public val contactProfile: ContactsPropertiesResponseContactProfile,
    public val endAzimuthDegrees: Double,
    public val endElevationDegrees: Double,
    public val errorMessage: String,
    public val groundStationName: String,
    public val id: String,
    public val maximumElevationDegrees: Double,
    public val name: String,
    public val reservationEndTime: String,
    public val reservationStartTime: String,
    public val rxEndTime: String,
    public val rxStartTime: String,
    public val startAzimuthDegrees: Double,
    public val startElevationDegrees: Double,
    public val status: String,
    public val systemData: SystemDataResponse,
    public val txEndTime: String,
    public val txStartTime: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.orbital.outputs.GetContactResult): GetContactResult = GetContactResult(
            antennaConfiguration = javaType.antennaConfiguration().let({ args0 ->
                com.pulumi.azurenative.orbital.kotlin.outputs.ContactsPropertiesResponseAntennaConfiguration.Companion.toKotlin(args0)
            }),
            contactProfile = javaType.contactProfile().let({ args0 ->
                com.pulumi.azurenative.orbital.kotlin.outputs.ContactsPropertiesResponseContactProfile.Companion.toKotlin(args0)
            }),
            endAzimuthDegrees = javaType.endAzimuthDegrees(),
            endElevationDegrees = javaType.endElevationDegrees(),
            errorMessage = javaType.errorMessage(),
            groundStationName = javaType.groundStationName(),
            id = javaType.id(),
            maximumElevationDegrees = javaType.maximumElevationDegrees(),
            name = javaType.name(),
            reservationEndTime = javaType.reservationEndTime(),
            reservationStartTime = javaType.reservationStartTime(),
            rxEndTime = javaType.rxEndTime(),
            rxStartTime = javaType.rxStartTime(),
            startAzimuthDegrees = javaType.startAzimuthDegrees(),
            startElevationDegrees = javaType.startElevationDegrees(),
            status = javaType.status(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.orbital.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            txEndTime = javaType.txEndTime(),
            txStartTime = javaType.txStartTime(),
            type = javaType.type(),
        )
    }
}
