@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.orbital.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Ground Station contains one or more antennas.
 * @property altitudeMeters Altitude of the ground station.
 * @property capabilities Ground station capabilities.
 * @property city City of ground station.
 * @property globalCommunicationsSite A reference to global communications site.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property latitudeDegrees Latitude of the ground station in decimal degrees.
 * @property location The geo-location where the resource lives
 * @property longitudeDegrees Longitude of the ground station in decimal degrees.
 * @property name The name of the resource
 * @property providerName Ground station provider name.
 * @property releaseMode Release Status of a ground station.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetGroundStationResult(
    public val altitudeMeters: Double? = null,
    public val capabilities: List<String>,
    public val city: String? = null,
    public val globalCommunicationsSite: GroundStationsPropertiesResponseGlobalCommunicationsSite,
    public val id: String,
    public val latitudeDegrees: Double? = null,
    public val location: String,
    public val longitudeDegrees: Double? = null,
    public val name: String,
    public val providerName: String? = null,
    public val releaseMode: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.orbital.outputs.GetGroundStationResult): GetGroundStationResult = GetGroundStationResult(
            altitudeMeters = javaType.altitudeMeters().map({ args0 -> args0 }).orElse(null),
            capabilities = javaType.capabilities().map({ args0 -> args0 }),
            city = javaType.city().map({ args0 -> args0 }).orElse(null),
            globalCommunicationsSite = javaType.globalCommunicationsSite().let({ args0 ->
                com.pulumi.azurenative.orbital.kotlin.outputs.GroundStationsPropertiesResponseGlobalCommunicationsSite.Companion.toKotlin(args0)
            }),
            id = javaType.id(),
            latitudeDegrees = javaType.latitudeDegrees().map({ args0 -> args0 }).orElse(null),
            location = javaType.location(),
            longitudeDegrees = javaType.longitudeDegrees().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            providerName = javaType.providerName().map({ args0 -> args0 }).orElse(null),
            releaseMode = javaType.releaseMode(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.orbital.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
