@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.orbital.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Response for the ListAvailableContacts API service call.
 * @property nextLink The URL to get the next set of results.
 * @property value A list of available contacts.
 */
public data class ListSpacecraftAvailableContactsResult(
    public val nextLink: String,
    public val `value`: List<AvailableContactsResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.orbital.outputs.ListSpacecraftAvailableContactsResult): ListSpacecraftAvailableContactsResult = ListSpacecraftAvailableContactsResult(
            nextLink = javaType.nextLink(),
            `value` = javaType.`value`().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.orbital.kotlin.outputs.AvailableContactsResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
