@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.orbital.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * List of authorized spacecraft links per ground station and the expiration date of the authorization.
 * @property authorizations Authorized Ground Stations
 * @property bandwidthMHz Bandwidth in MHz.
 * @property centerFrequencyMHz Center Frequency in MHz.
 * @property direction Direction (Uplink or Downlink).
 * @property name Link name.
 * @property polarization Polarization. e.g. (RHCP, LHCP).
 */
public data class SpacecraftLinkResponse(
    public val authorizations: List<AuthorizedGroundstationResponse>,
    public val bandwidthMHz: Double,
    public val centerFrequencyMHz: Double,
    public val direction: String,
    public val name: String,
    public val polarization: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.orbital.outputs.SpacecraftLinkResponse): SpacecraftLinkResponse = SpacecraftLinkResponse(
            authorizations = javaType.authorizations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.orbital.kotlin.outputs.AuthorizedGroundstationResponse.Companion.toKotlin(args0)
                })
            }),
            bandwidthMHz = javaType.bandwidthMHz(),
            centerFrequencyMHz = javaType.centerFrequencyMHz(),
            direction = javaType.direction(),
            name = javaType.name(),
            polarization = javaType.polarization(),
        )
    }
}
