@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.peering.kotlin

import com.pulumi.azurenative.peering.PeeringFunctions.getConnectionMonitorTestPlain
import com.pulumi.azurenative.peering.PeeringFunctions.getPeerAsnPlain
import com.pulumi.azurenative.peering.PeeringFunctions.getPeeringPlain
import com.pulumi.azurenative.peering.PeeringFunctions.getPeeringServicePlain
import com.pulumi.azurenative.peering.PeeringFunctions.getPrefixPlain
import com.pulumi.azurenative.peering.PeeringFunctions.getRegisteredAsnPlain
import com.pulumi.azurenative.peering.PeeringFunctions.getRegisteredPrefixPlain
import com.pulumi.azurenative.peering.kotlin.inputs.GetConnectionMonitorTestPlainArgs
import com.pulumi.azurenative.peering.kotlin.inputs.GetConnectionMonitorTestPlainArgsBuilder
import com.pulumi.azurenative.peering.kotlin.inputs.GetPeerAsnPlainArgs
import com.pulumi.azurenative.peering.kotlin.inputs.GetPeerAsnPlainArgsBuilder
import com.pulumi.azurenative.peering.kotlin.inputs.GetPeeringPlainArgs
import com.pulumi.azurenative.peering.kotlin.inputs.GetPeeringPlainArgsBuilder
import com.pulumi.azurenative.peering.kotlin.inputs.GetPeeringServicePlainArgs
import com.pulumi.azurenative.peering.kotlin.inputs.GetPeeringServicePlainArgsBuilder
import com.pulumi.azurenative.peering.kotlin.inputs.GetPrefixPlainArgs
import com.pulumi.azurenative.peering.kotlin.inputs.GetPrefixPlainArgsBuilder
import com.pulumi.azurenative.peering.kotlin.inputs.GetRegisteredAsnPlainArgs
import com.pulumi.azurenative.peering.kotlin.inputs.GetRegisteredAsnPlainArgsBuilder
import com.pulumi.azurenative.peering.kotlin.inputs.GetRegisteredPrefixPlainArgs
import com.pulumi.azurenative.peering.kotlin.inputs.GetRegisteredPrefixPlainArgsBuilder
import com.pulumi.azurenative.peering.kotlin.outputs.GetConnectionMonitorTestResult
import com.pulumi.azurenative.peering.kotlin.outputs.GetPeerAsnResult
import com.pulumi.azurenative.peering.kotlin.outputs.GetPeeringResult
import com.pulumi.azurenative.peering.kotlin.outputs.GetPeeringServiceResult
import com.pulumi.azurenative.peering.kotlin.outputs.GetPrefixResult
import com.pulumi.azurenative.peering.kotlin.outputs.GetRegisteredAsnResult
import com.pulumi.azurenative.peering.kotlin.outputs.GetRegisteredPrefixResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.peering.kotlin.outputs.GetConnectionMonitorTestResult.Companion.toKotlin as getConnectionMonitorTestResultToKotlin
import com.pulumi.azurenative.peering.kotlin.outputs.GetPeerAsnResult.Companion.toKotlin as getPeerAsnResultToKotlin
import com.pulumi.azurenative.peering.kotlin.outputs.GetPeeringResult.Companion.toKotlin as getPeeringResultToKotlin
import com.pulumi.azurenative.peering.kotlin.outputs.GetPeeringServiceResult.Companion.toKotlin as getPeeringServiceResultToKotlin
import com.pulumi.azurenative.peering.kotlin.outputs.GetPrefixResult.Companion.toKotlin as getPrefixResultToKotlin
import com.pulumi.azurenative.peering.kotlin.outputs.GetRegisteredAsnResult.Companion.toKotlin as getRegisteredAsnResultToKotlin
import com.pulumi.azurenative.peering.kotlin.outputs.GetRegisteredPrefixResult.Companion.toKotlin as getRegisteredPrefixResultToKotlin

public object PeeringFunctions {
    /**
     * Gets an existing connection monitor test with the specified name under the given subscription, resource group and peering service.
     * Azure REST API version: 2022-10-01.
     * @param argument null
     * @return The Connection Monitor Test class.
     */
    public suspend fun getConnectionMonitorTest(argument: GetConnectionMonitorTestPlainArgs): GetConnectionMonitorTestResult =
        getConnectionMonitorTestResultToKotlin(getConnectionMonitorTestPlain(argument.toJava()).await())

    /**
     * @see [getConnectionMonitorTest].
     * @param connectionMonitorTestName The name of the connection monitor test
     * @param peeringServiceName The name of the peering service.
     * @param resourceGroupName The name of the resource group.
     * @return The Connection Monitor Test class.
     */
    public suspend fun getConnectionMonitorTest(
        connectionMonitorTestName: String,
        peeringServiceName: String,
        resourceGroupName: String,
    ): GetConnectionMonitorTestResult {
        val argument = GetConnectionMonitorTestPlainArgs(
            connectionMonitorTestName = connectionMonitorTestName,
            peeringServiceName = peeringServiceName,
            resourceGroupName = resourceGroupName,
        )
        return getConnectionMonitorTestResultToKotlin(getConnectionMonitorTestPlain(argument.toJava()).await())
    }

    /**
     * @see [getConnectionMonitorTest].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;peering&#46;kotlin&#46;inputs&#46;GetConnectionMonitorTestPlainArgs].
     * @return The Connection Monitor Test class.
     */
    public suspend fun getConnectionMonitorTest(argument: suspend GetConnectionMonitorTestPlainArgsBuilder.() -> Unit): GetConnectionMonitorTestResult {
        val builder = GetConnectionMonitorTestPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getConnectionMonitorTestResultToKotlin(getConnectionMonitorTestPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the peer ASN with the specified name under the given subscription.
     * Azure REST API version: 2022-10-01.
     * Other available API versions: 2019-09-01-preview, 2021-01-01.
     * @param argument null
     * @return The essential information related to the peer's ASN.
     */
    public suspend fun getPeerAsn(argument: GetPeerAsnPlainArgs): GetPeerAsnResult =
        getPeerAsnResultToKotlin(getPeerAsnPlain(argument.toJava()).await())

    /**
     * @see [getPeerAsn].
     * @param peerAsnName The peer ASN name.
     * @return The essential information related to the peer's ASN.
     */
    public suspend fun getPeerAsn(peerAsnName: String): GetPeerAsnResult {
        val argument = GetPeerAsnPlainArgs(
            peerAsnName = peerAsnName,
        )
        return getPeerAsnResultToKotlin(getPeerAsnPlain(argument.toJava()).await())
    }

    /**
     * @see [getPeerAsn].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;peering&#46;kotlin&#46;inputs&#46;GetPeerAsnPlainArgs].
     * @return The essential information related to the peer's ASN.
     */
    public suspend fun getPeerAsn(argument: suspend GetPeerAsnPlainArgsBuilder.() -> Unit): GetPeerAsnResult {
        val builder = GetPeerAsnPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPeerAsnResultToKotlin(getPeerAsnPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets an existing peering with the specified name under the given subscription and resource group.
     * Azure REST API version: 2022-10-01.
     * @param argument null
     * @return Peering is a logical representation of a set of connections to the Microsoft Cloud Edge at a location.
     */
    public suspend fun getPeering(argument: GetPeeringPlainArgs): GetPeeringResult =
        getPeeringResultToKotlin(getPeeringPlain(argument.toJava()).await())

    /**
     * @see [getPeering].
     * @param peeringName The name of the peering.
     * @param resourceGroupName The name of the resource group.
     * @return Peering is a logical representation of a set of connections to the Microsoft Cloud Edge at a location.
     */
    public suspend fun getPeering(peeringName: String, resourceGroupName: String): GetPeeringResult {
        val argument = GetPeeringPlainArgs(
            peeringName = peeringName,
            resourceGroupName = resourceGroupName,
        )
        return getPeeringResultToKotlin(getPeeringPlain(argument.toJava()).await())
    }

    /**
     * @see [getPeering].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;peering&#46;kotlin&#46;inputs&#46;GetPeeringPlainArgs].
     * @return Peering is a logical representation of a set of connections to the Microsoft Cloud Edge at a location.
     */
    public suspend fun getPeering(argument: suspend GetPeeringPlainArgsBuilder.() -> Unit): GetPeeringResult {
        val builder = GetPeeringPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPeeringResultToKotlin(getPeeringPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets an existing peering service with the specified name under the given subscription and resource group.
     * Azure REST API version: 2022-10-01.
     * @param argument null
     * @return Peering Service
     */
    public suspend fun getPeeringService(argument: GetPeeringServicePlainArgs): GetPeeringServiceResult =
        getPeeringServiceResultToKotlin(getPeeringServicePlain(argument.toJava()).await())

    /**
     * @see [getPeeringService].
     * @param peeringServiceName The name of the peering.
     * @param resourceGroupName The name of the resource group.
     * @return Peering Service
     */
    public suspend fun getPeeringService(peeringServiceName: String, resourceGroupName: String): GetPeeringServiceResult {
        val argument = GetPeeringServicePlainArgs(
            peeringServiceName = peeringServiceName,
            resourceGroupName = resourceGroupName,
        )
        return getPeeringServiceResultToKotlin(getPeeringServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getPeeringService].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;peering&#46;kotlin&#46;inputs&#46;GetPeeringServicePlainArgs].
     * @return Peering Service
     */
    public suspend fun getPeeringService(argument: suspend GetPeeringServicePlainArgsBuilder.() -> Unit): GetPeeringServiceResult {
        val builder = GetPeeringServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPeeringServiceResultToKotlin(getPeeringServicePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets an existing prefix with the specified name under the given subscription, resource group and peering service.
     * Azure REST API version: 2022-10-01.
     * @param argument null
     * @return The peering service prefix class.
     */
    public suspend fun getPrefix(argument: GetPrefixPlainArgs): GetPrefixResult =
        getPrefixResultToKotlin(getPrefixPlain(argument.toJava()).await())

    /**
     * @see [getPrefix].
     * @param expand The properties to be expanded.
     * @param peeringServiceName The name of the peering service.
     * @param prefixName The name of the prefix.
     * @param resourceGroupName The name of the resource group.
     * @return The peering service prefix class.
     */
    public suspend fun getPrefix(
        expand: String? = null,
        peeringServiceName: String,
        prefixName: String,
        resourceGroupName: String,
    ): GetPrefixResult {
        val argument = GetPrefixPlainArgs(
            expand = expand,
            peeringServiceName = peeringServiceName,
            prefixName = prefixName,
            resourceGroupName = resourceGroupName,
        )
        return getPrefixResultToKotlin(getPrefixPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrefix].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;peering&#46;kotlin&#46;inputs&#46;GetPrefixPlainArgs].
     * @return The peering service prefix class.
     */
    public suspend fun getPrefix(argument: suspend GetPrefixPlainArgsBuilder.() -> Unit): GetPrefixResult {
        val builder = GetPrefixPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrefixResultToKotlin(getPrefixPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets an existing registered ASN with the specified name under the given subscription, resource group and peering.
     * Azure REST API version: 2022-10-01.
     * @param argument null
     * @return The customer's ASN that is registered by the peering service provider.
     */
    public suspend fun getRegisteredAsn(argument: GetRegisteredAsnPlainArgs): GetRegisteredAsnResult =
        getRegisteredAsnResultToKotlin(getRegisteredAsnPlain(argument.toJava()).await())

    /**
     * @see [getRegisteredAsn].
     * @param peeringName The name of the peering.
     * @param registeredAsnName The name of the registered ASN.
     * @param resourceGroupName The name of the resource group.
     * @return The customer's ASN that is registered by the peering service provider.
     */
    public suspend fun getRegisteredAsn(
        peeringName: String,
        registeredAsnName: String,
        resourceGroupName: String,
    ): GetRegisteredAsnResult {
        val argument = GetRegisteredAsnPlainArgs(
            peeringName = peeringName,
            registeredAsnName = registeredAsnName,
            resourceGroupName = resourceGroupName,
        )
        return getRegisteredAsnResultToKotlin(getRegisteredAsnPlain(argument.toJava()).await())
    }

    /**
     * @see [getRegisteredAsn].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;peering&#46;kotlin&#46;inputs&#46;GetRegisteredAsnPlainArgs].
     * @return The customer's ASN that is registered by the peering service provider.
     */
    public suspend fun getRegisteredAsn(argument: suspend GetRegisteredAsnPlainArgsBuilder.() -> Unit): GetRegisteredAsnResult {
        val builder = GetRegisteredAsnPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRegisteredAsnResultToKotlin(getRegisteredAsnPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets an existing registered prefix with the specified name under the given subscription, resource group and peering.
     * Azure REST API version: 2022-10-01.
     * @param argument null
     * @return The customer's prefix that is registered by the peering service provider.
     */
    public suspend fun getRegisteredPrefix(argument: GetRegisteredPrefixPlainArgs): GetRegisteredPrefixResult =
        getRegisteredPrefixResultToKotlin(getRegisteredPrefixPlain(argument.toJava()).await())

    /**
     * @see [getRegisteredPrefix].
     * @param peeringName The name of the peering.
     * @param registeredPrefixName The name of the registered prefix.
     * @param resourceGroupName The name of the resource group.
     * @return The customer's prefix that is registered by the peering service provider.
     */
    public suspend fun getRegisteredPrefix(
        peeringName: String,
        registeredPrefixName: String,
        resourceGroupName: String,
    ): GetRegisteredPrefixResult {
        val argument = GetRegisteredPrefixPlainArgs(
            peeringName = peeringName,
            registeredPrefixName = registeredPrefixName,
            resourceGroupName = resourceGroupName,
        )
        return getRegisteredPrefixResultToKotlin(getRegisteredPrefixPlain(argument.toJava()).await())
    }

    /**
     * @see [getRegisteredPrefix].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;peering&#46;kotlin&#46;inputs&#46;GetRegisteredPrefixPlainArgs].
     * @return The customer's prefix that is registered by the peering service provider.
     */
    public suspend fun getRegisteredPrefix(argument: suspend GetRegisteredPrefixPlainArgsBuilder.() -> Unit): GetRegisteredPrefixResult {
        val builder = GetRegisteredPrefixPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRegisteredPrefixResultToKotlin(getRegisteredPrefixPlain(builtArgument.toJava()).await())
    }
}
