@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.peering.kotlin

import com.pulumi.azurenative.peering.kotlin.outputs.PeeringServicePrefixEventResponse
import com.pulumi.azurenative.peering.kotlin.outputs.PeeringServicePrefixEventResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [Prefix].
 */
@PulumiTagMarker
public class PrefixResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PrefixArgs = PrefixArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PrefixArgsBuilder.() -> Unit) {
        val builder = PrefixArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Prefix {
        val builtJavaResource = com.pulumi.azurenative.peering.Prefix(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Prefix(builtJavaResource)
    }
}

/**
 * The peering service prefix class.
 * Azure REST API version: 2022-10-01. Prior API version in Azure Native 1.x: 2021-01-01.
 * ## Example Usage
 * ### Create or update a prefix for the peering service
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var prefix = new AzureNative.Peering.Prefix("prefix", new()
 *     {
 *         PeeringServiceName = "peeringServiceName",
 *         PeeringServicePrefixKey = "00000000-0000-0000-0000-000000000000",
 *         Prefix = "192.168.1.0/24",
 *         PrefixName = "peeringServicePrefixName",
 *         ResourceGroupName = "rgName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/peering/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := peering.NewPrefix(ctx, "prefix", &peering.PrefixArgs{
 * 			PeeringServiceName:      pulumi.String("peeringServiceName"),
 * 			PeeringServicePrefixKey: pulumi.String("00000000-0000-0000-0000-000000000000"),
 * 			Prefix:                  pulumi.String("192.168.1.0/24"),
 * 			PrefixName:              pulumi.String("peeringServicePrefixName"),
 * 			ResourceGroupName:       pulumi.String("rgName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.peering.Prefix;
 * import com.pulumi.azurenative.peering.PrefixArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var prefix = new Prefix("prefix", PrefixArgs.builder()
 *             .peeringServiceName("peeringServiceName")
 *             .peeringServicePrefixKey("00000000-0000-0000-0000-000000000000")
 *             .prefix("192.168.1.0/24")
 *             .prefixName("peeringServicePrefixName")
 *             .resourceGroupName("rgName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:peering:Prefix peeringServicePrefixName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Peering/peeringServices/{peeringServiceName}/prefixes/{prefixName}
 * ```
 */
public class Prefix internal constructor(
    override val javaResource: com.pulumi.azurenative.peering.Prefix,
) : KotlinCustomResource(javaResource, PrefixMapper) {
    /**
     * The error message for validation state
     */
    public val errorMessage: Output<String>
        get() = javaResource.errorMessage().applyValue({ args0 -> args0 })

    /**
     * The list of events for peering service prefix
     */
    public val events: Output<List<PeeringServicePrefixEventResponse>>
        get() = javaResource.events().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * The prefix learned type
     */
    public val learnedType: Output<String>
        get() = javaResource.learnedType().applyValue({ args0 -> args0 })

    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The peering service prefix key
     */
    public val peeringServicePrefixKey: Output<String>?
        get() = javaResource.peeringServicePrefixKey().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The prefix from which your traffic originates.
     */
    public val prefix: Output<String>?
        get() = javaResource.prefix().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The prefix validation state
     */
    public val prefixValidationState: Output<String>
        get() = javaResource.prefixValidationState().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PrefixMapper : ResourceMapper<Prefix> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.peering.Prefix::class == javaResource::class

    override fun map(javaResource: Resource): Prefix = Prefix(
        javaResource as
            com.pulumi.azurenative.peering.Prefix,
    )
}

/**
 * @see [Prefix].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Prefix].
 */
public suspend fun prefix(name: String, block: suspend PrefixResourceBuilder.() -> Unit): Prefix {
    val builder = PrefixResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Prefix].
 * @param name The _unique_ name of the resulting resource.
 */
public fun prefix(name: String): Prefix {
    val builder = PrefixResourceBuilder()
    builder.name(name)
    return builder.build()
}
