@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.peering.kotlin.inputs

import com.pulumi.azurenative.peering.inputs.DirectConnectionArgs.builder
import com.pulumi.azurenative.peering.kotlin.enums.SessionAddressProvider
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The properties that define a direct connection.
 * @property bandwidthInMbps The bandwidth of the connection.
 * @property bgpSession The BGP session associated with the connection.
 * @property connectionIdentifier The unique identifier (GUID) for the connection.
 * @property peeringDBFacilityId The PeeringDB.com ID of the facility at which the connection has to be set up.
 * @property sessionAddressProvider The field indicating if Microsoft provides session ip addresses.
 * @property useForPeeringService The flag that indicates whether or not the connection is used for peering service.
 */
public data class DirectConnectionArgs(
    public val bandwidthInMbps: Output<Int>? = null,
    public val bgpSession: Output<BgpSessionArgs>? = null,
    public val connectionIdentifier: Output<String>? = null,
    public val peeringDBFacilityId: Output<Int>? = null,
    public val sessionAddressProvider: Output<Either<String, SessionAddressProvider>>? = null,
    public val useForPeeringService: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.peering.inputs.DirectConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.peering.inputs.DirectConnectionArgs =
        com.pulumi.azurenative.peering.inputs.DirectConnectionArgs.builder()
            .bandwidthInMbps(bandwidthInMbps?.applyValue({ args0 -> args0 }))
            .bgpSession(bgpSession?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .connectionIdentifier(connectionIdentifier?.applyValue({ args0 -> args0 }))
            .peeringDBFacilityId(peeringDBFacilityId?.applyValue({ args0 -> args0 }))
            .sessionAddressProvider(
                sessionAddressProvider?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .useForPeeringService(useForPeeringService?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DirectConnectionArgs].
 */
@PulumiTagMarker
public class DirectConnectionArgsBuilder internal constructor() {
    private var bandwidthInMbps: Output<Int>? = null

    private var bgpSession: Output<BgpSessionArgs>? = null

    private var connectionIdentifier: Output<String>? = null

    private var peeringDBFacilityId: Output<Int>? = null

    private var sessionAddressProvider: Output<Either<String, SessionAddressProvider>>? = null

    private var useForPeeringService: Output<Boolean>? = null

    /**
     * @param value The bandwidth of the connection.
     */
    @JvmName("ibtnvyluaonfwghf")
    public suspend fun bandwidthInMbps(`value`: Output<Int>) {
        this.bandwidthInMbps = value
    }

    /**
     * @param value The BGP session associated with the connection.
     */
    @JvmName("pmppxsikwbynwbtl")
    public suspend fun bgpSession(`value`: Output<BgpSessionArgs>) {
        this.bgpSession = value
    }

    /**
     * @param value The unique identifier (GUID) for the connection.
     */
    @JvmName("mjvntdrrmnmycpns")
    public suspend fun connectionIdentifier(`value`: Output<String>) {
        this.connectionIdentifier = value
    }

    /**
     * @param value The PeeringDB.com ID of the facility at which the connection has to be set up.
     */
    @JvmName("obsugoekdbjusplw")
    public suspend fun peeringDBFacilityId(`value`: Output<Int>) {
        this.peeringDBFacilityId = value
    }

    /**
     * @param value The field indicating if Microsoft provides session ip addresses.
     */
    @JvmName("ubfaywoijsugjsgy")
    public suspend fun sessionAddressProvider(`value`: Output<Either<String, SessionAddressProvider>>) {
        this.sessionAddressProvider = value
    }

    /**
     * @param value The flag that indicates whether or not the connection is used for peering service.
     */
    @JvmName("xvkkxchmphydyfij")
    public suspend fun useForPeeringService(`value`: Output<Boolean>) {
        this.useForPeeringService = value
    }

    /**
     * @param value The bandwidth of the connection.
     */
    @JvmName("ektjcddogmsbcxsv")
    public suspend fun bandwidthInMbps(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bandwidthInMbps = mapped
    }

    /**
     * @param value The BGP session associated with the connection.
     */
    @JvmName("sehvaarqxxwmbqsp")
    public suspend fun bgpSession(`value`: BgpSessionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bgpSession = mapped
    }

    /**
     * @param argument The BGP session associated with the connection.
     */
    @JvmName("uslepfgmineachfr")
    public suspend fun bgpSession(argument: suspend BgpSessionArgsBuilder.() -> Unit) {
        val toBeMapped = BgpSessionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.bgpSession = mapped
    }

    /**
     * @param value The unique identifier (GUID) for the connection.
     */
    @JvmName("ltmxdwovvbhcvlxu")
    public suspend fun connectionIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionIdentifier = mapped
    }

    /**
     * @param value The PeeringDB.com ID of the facility at which the connection has to be set up.
     */
    @JvmName("mifnaqbyrujayayw")
    public suspend fun peeringDBFacilityId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peeringDBFacilityId = mapped
    }

    /**
     * @param value The field indicating if Microsoft provides session ip addresses.
     */
    @JvmName("cssidoffkaxotrmj")
    public suspend fun sessionAddressProvider(`value`: Either<String, SessionAddressProvider>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sessionAddressProvider = mapped
    }

    /**
     * @param value The field indicating if Microsoft provides session ip addresses.
     */
    @JvmName("pqockqbjkrostauv")
    public fun sessionAddressProvider(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SessionAddressProvider>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sessionAddressProvider = mapped
    }

    /**
     * @param value The field indicating if Microsoft provides session ip addresses.
     */
    @JvmName("essgsiytlqjeedwn")
    public fun sessionAddressProvider(`value`: SessionAddressProvider) {
        val toBeMapped = Either.ofRight<String, SessionAddressProvider>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sessionAddressProvider = mapped
    }

    /**
     * @param value The flag that indicates whether or not the connection is used for peering service.
     */
    @JvmName("ucnhsuawncihsowx")
    public suspend fun useForPeeringService(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useForPeeringService = mapped
    }

    internal fun build(): DirectConnectionArgs = DirectConnectionArgs(
        bandwidthInMbps = bandwidthInMbps,
        bgpSession = bgpSession,
        connectionIdentifier = connectionIdentifier,
        peeringDBFacilityId = peeringDBFacilityId,
        sessionAddressProvider = sessionAddressProvider,
        useForPeeringService = useForPeeringService,
    )
}
