@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.peering.kotlin.inputs

import com.pulumi.azurenative.peering.inputs.GetPeerAsnPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property peerAsnName The peer ASN name.
 */
public data class GetPeerAsnPlainArgs(
    public val peerAsnName: String,
) : ConvertibleToJava<com.pulumi.azurenative.peering.inputs.GetPeerAsnPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.peering.inputs.GetPeerAsnPlainArgs =
        com.pulumi.azurenative.peering.inputs.GetPeerAsnPlainArgs.builder()
            .peerAsnName(peerAsnName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPeerAsnPlainArgs].
 */
@PulumiTagMarker
public class GetPeerAsnPlainArgsBuilder internal constructor() {
    private var peerAsnName: String? = null

    /**
     * @param value The peer ASN name.
     */
    @JvmName("rbffmqgekoforogh")
    public suspend fun peerAsnName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.peerAsnName = mapped
    }

    internal fun build(): GetPeerAsnPlainArgs = GetPeerAsnPlainArgs(
        peerAsnName = peerAsnName ?: throw PulumiNullFieldException("peerAsnName"),
    )
}
