@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.peering.kotlin.inputs

import com.pulumi.azurenative.peering.inputs.GetRegisteredAsnPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property peeringName The name of the peering.
 * @property registeredAsnName The name of the registered ASN.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetRegisteredAsnPlainArgs(
    public val peeringName: String,
    public val registeredAsnName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.peering.inputs.GetRegisteredAsnPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.peering.inputs.GetRegisteredAsnPlainArgs =
        com.pulumi.azurenative.peering.inputs.GetRegisteredAsnPlainArgs.builder()
            .peeringName(peeringName.let({ args0 -> args0 }))
            .registeredAsnName(registeredAsnName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRegisteredAsnPlainArgs].
 */
@PulumiTagMarker
public class GetRegisteredAsnPlainArgsBuilder internal constructor() {
    private var peeringName: String? = null

    private var registeredAsnName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the peering.
     */
    @JvmName("gbdjaevpxlnkfwej")
    public suspend fun peeringName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.peeringName = mapped
    }

    /**
     * @param value The name of the registered ASN.
     */
    @JvmName("ixmnvtjiiiokolll")
    public suspend fun registeredAsnName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.registeredAsnName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("njqfhcaqolrxipka")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetRegisteredAsnPlainArgs = GetRegisteredAsnPlainArgs(
        peeringName = peeringName ?: throw PulumiNullFieldException("peeringName"),
        registeredAsnName = registeredAsnName ?: throw PulumiNullFieldException("registeredAsnName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
