@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.peering.kotlin.inputs

import com.pulumi.azurenative.peering.inputs.PeeringPropertiesExchangeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The properties that define an exchange peering.
 * @property connections The set of connections that constitute an exchange peering.
 * @property peerAsn The reference of the peer ASN.
 */
public data class PeeringPropertiesExchangeArgs(
    public val connections: Output<List<ExchangeConnectionArgs>>? = null,
    public val peerAsn: Output<SubResourceArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.peering.inputs.PeeringPropertiesExchangeArgs> {
    override fun toJava(): com.pulumi.azurenative.peering.inputs.PeeringPropertiesExchangeArgs =
        com.pulumi.azurenative.peering.inputs.PeeringPropertiesExchangeArgs.builder()
            .connections(
                connections?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .peerAsn(peerAsn?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [PeeringPropertiesExchangeArgs].
 */
@PulumiTagMarker
public class PeeringPropertiesExchangeArgsBuilder internal constructor() {
    private var connections: Output<List<ExchangeConnectionArgs>>? = null

    private var peerAsn: Output<SubResourceArgs>? = null

    /**
     * @param value The set of connections that constitute an exchange peering.
     */
    @JvmName("olsynykseaytdspt")
    public suspend fun connections(`value`: Output<List<ExchangeConnectionArgs>>) {
        this.connections = value
    }

    @JvmName("tgsfuueenvetgksv")
    public suspend fun connections(vararg values: Output<ExchangeConnectionArgs>) {
        this.connections = Output.all(values.asList())
    }

    /**
     * @param values The set of connections that constitute an exchange peering.
     */
    @JvmName("fgrfwkhxsppayxyy")
    public suspend fun connections(values: List<Output<ExchangeConnectionArgs>>) {
        this.connections = Output.all(values)
    }

    /**
     * @param value The reference of the peer ASN.
     */
    @JvmName("hvorsbbbwgcxtppg")
    public suspend fun peerAsn(`value`: Output<SubResourceArgs>) {
        this.peerAsn = value
    }

    /**
     * @param value The set of connections that constitute an exchange peering.
     */
    @JvmName("aldwpaqivefgdygb")
    public suspend fun connections(`value`: List<ExchangeConnectionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connections = mapped
    }

    /**
     * @param argument The set of connections that constitute an exchange peering.
     */
    @JvmName("jjtqxkvunyvpkesn")
    public suspend fun connections(argument: List<suspend ExchangeConnectionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ExchangeConnectionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.connections = mapped
    }

    /**
     * @param argument The set of connections that constitute an exchange peering.
     */
    @JvmName("qtrrsrmipphgehbj")
    public suspend fun connections(vararg argument: suspend ExchangeConnectionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ExchangeConnectionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.connections = mapped
    }

    /**
     * @param argument The set of connections that constitute an exchange peering.
     */
    @JvmName("obkxcrlndckucsao")
    public suspend fun connections(argument: suspend ExchangeConnectionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ExchangeConnectionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.connections = mapped
    }

    /**
     * @param values The set of connections that constitute an exchange peering.
     */
    @JvmName("nghvvybrxvgntgul")
    public suspend fun connections(vararg values: ExchangeConnectionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connections = mapped
    }

    /**
     * @param value The reference of the peer ASN.
     */
    @JvmName("caufqogpqqataknp")
    public suspend fun peerAsn(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peerAsn = mapped
    }

    /**
     * @param argument The reference of the peer ASN.
     */
    @JvmName("itcktrsnihgemqbn")
    public suspend fun peerAsn(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.peerAsn = mapped
    }

    internal fun build(): PeeringPropertiesExchangeArgs = PeeringPropertiesExchangeArgs(
        connections = connections,
        peerAsn = peerAsn,
    )
}
