@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.peering.kotlin.inputs

import com.pulumi.azurenative.peering.inputs.PeeringServiceSkuArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The SKU that defines the type of the peering service.
 * @property name The name of the peering service SKU.
 */
public data class PeeringServiceSkuArgs(
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.peering.inputs.PeeringServiceSkuArgs> {
    override fun toJava(): com.pulumi.azurenative.peering.inputs.PeeringServiceSkuArgs =
        com.pulumi.azurenative.peering.inputs.PeeringServiceSkuArgs.builder()
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PeeringServiceSkuArgs].
 */
@PulumiTagMarker
public class PeeringServiceSkuArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    /**
     * @param value The name of the peering service SKU.
     */
    @JvmName("bmuosoeummqnhpen")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the peering service SKU.
     */
    @JvmName("ytgesmiyegyrkusd")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): PeeringServiceSkuArgs = PeeringServiceSkuArgs(
        name = name,
    )
}
