@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.peering.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The properties that define a direct connection.
 * @property bandwidthInMbps The bandwidth of the connection.
 * @property bgpSession The BGP session associated with the connection.
 * @property connectionIdentifier The unique identifier (GUID) for the connection.
 * @property connectionState The state of the connection.
 * @property errorMessage The error message related to the connection state, if any.
 * @property microsoftTrackingId The ID used within Microsoft's peering provisioning system to track the connection
 * @property peeringDBFacilityId The PeeringDB.com ID of the facility at which the connection has to be set up.
 * @property provisionedBandwidthInMbps The bandwidth that is actually provisioned.
 * @property sessionAddressProvider The field indicating if Microsoft provides session ip addresses.
 * @property useForPeeringService The flag that indicates whether or not the connection is used for peering service.
 */
public data class DirectConnectionResponse(
    public val bandwidthInMbps: Int? = null,
    public val bgpSession: BgpSessionResponse? = null,
    public val connectionIdentifier: String? = null,
    public val connectionState: String,
    public val errorMessage: String,
    public val microsoftTrackingId: String,
    public val peeringDBFacilityId: Int? = null,
    public val provisionedBandwidthInMbps: Int,
    public val sessionAddressProvider: String? = null,
    public val useForPeeringService: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.peering.outputs.DirectConnectionResponse): DirectConnectionResponse = DirectConnectionResponse(
            bandwidthInMbps = javaType.bandwidthInMbps().map({ args0 -> args0 }).orElse(null),
            bgpSession = javaType.bgpSession().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.peering.kotlin.outputs.BgpSessionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            connectionIdentifier = javaType.connectionIdentifier().map({ args0 -> args0 }).orElse(null),
            connectionState = javaType.connectionState(),
            errorMessage = javaType.errorMessage(),
            microsoftTrackingId = javaType.microsoftTrackingId(),
            peeringDBFacilityId = javaType.peeringDBFacilityId().map({ args0 -> args0 }).orElse(null),
            provisionedBandwidthInMbps = javaType.provisionedBandwidthInMbps(),
            sessionAddressProvider = javaType.sessionAddressProvider().map({ args0 -> args0 }).orElse(null),
            useForPeeringService = javaType.useForPeeringService().map({ args0 -> args0 }).orElse(null),
        )
    }
}
