@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.peering.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The Connection Monitor Test class.
 * @property destination The Connection Monitor test destination
 * @property destinationPort The Connection Monitor test destination port
 * @property id The ID of the resource.
 * @property isTestSuccessful The flag that indicates if the Connection Monitor test is successful or not.
 * @property name The name of the resource.
 * @property path The path representing the Connection Monitor test.
 * @property provisioningState The provisioning state of the resource.
 * @property sourceAgent The Connection Monitor test source agent
 * @property testFrequencyInSec The Connection Monitor test frequency in seconds
 * @property type The type of the resource.
 */
public data class GetConnectionMonitorTestResult(
    public val destination: String? = null,
    public val destinationPort: Int? = null,
    public val id: String,
    public val isTestSuccessful: Boolean,
    public val name: String,
    public val path: List<String>,
    public val provisioningState: String,
    public val sourceAgent: String? = null,
    public val testFrequencyInSec: Int? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.peering.outputs.GetConnectionMonitorTestResult): GetConnectionMonitorTestResult = GetConnectionMonitorTestResult(
            destination = javaType.destination().map({ args0 -> args0 }).orElse(null),
            destinationPort = javaType.destinationPort().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            isTestSuccessful = javaType.isTestSuccessful(),
            name = javaType.name(),
            path = javaType.path().map({ args0 -> args0 }),
            provisioningState = javaType.provisioningState(),
            sourceAgent = javaType.sourceAgent().map({ args0 -> args0 }).orElse(null),
            testFrequencyInSec = javaType.testFrequencyInSec().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
